/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.TestLoggerFactory;
import de.cuioss.tools.string.MoreStrings;
import java.util.EnumSet;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

public enum TestLogLevel {
    TRACE(Level.FINER),
    DEBUG(Level.FINE),
    INFO(Level.INFO),
    WARN(Level.WARNING),
    ERROR(Level.SEVERE);

    private final Level juliLevel;

    boolean isEnabled(Logger logger) {
        return logger.isLoggable(this.getJuliLevel());
    }

    public TestLogLevel setAsRootLevel() {
        return this.addLogger("");
    }

    public TestLogLevel addLogger(Class<?> className) {
        if (null == className) {
            return this.addLogger("");
        }
        return this.addLogger(className.getName());
    }

    public TestLogLevel addLogger(String loggerName) {
        TestLoggerFactory.addLogger(this, loggerName);
        return this;
    }

    public static TestLogLevel parse(Level level) {
        Objects.requireNonNull(level);
        for (TestLogLevel testLogLevel : TestLogLevel.values()) {
            if (!testLogLevel.juliLevel.equals(level)) continue;
            return testLogLevel;
        }
        return INFO;
    }

    static TestLogLevel getLevelOrDefault(String levelAsAString, TestLogLevel defaultLevel) {
        Objects.requireNonNull(defaultLevel);
        if (MoreStrings.isEmpty((CharSequence)levelAsAString)) {
            return defaultLevel;
        }
        try {
            return TestLogLevel.valueOf(levelAsAString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Unable to determine logger, expected one of %s, but was %s", EnumSet.allOf(TestLogLevel.class), levelAsAString);
            Logger.getLogger(TestLogLevel.class.getName()).log(Level.FINE, message, e);
            return defaultLevel;
        }
    }

    @Generated
    private TestLogLevel(Level juliLevel) {
        this.juliLevel = juliLevel;
    }

    @Generated
    public Level getJuliLevel() {
        return this.juliLevel;
    }
}

