/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.ConsoleHandlerModifier;
import de.cuioss.test.juli.StaticLoggerConfigurator;
import de.cuioss.test.juli.TestLogHandler;
import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.tools.string.MoreStrings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import lombok.Generated;

public final class TestLoggerFactory {
    private static final StaticLoggerConfigurator configuration = new StaticLoggerConfigurator();
    private static final ConsoleHandlerModifier CONSOLE_HANDLER = new ConsoleHandlerModifier();

    public static void install() {
        if (TestLoggerFactory.getTestHandlerOption().isEmpty()) {
            CONSOLE_HANDLER.saveLevel();
            TestLoggerFactory.getRootLogger().addHandler(new TestLogHandler());
        }
    }

    public static void uninstall() {
        CONSOLE_HANDLER.restoreLevel();
        Optional<TestLogHandler> testHandlerOption = TestLoggerFactory.getTestHandlerOption();
        testHandlerOption.ifPresent(testLogHandler -> TestLoggerFactory.getRootLogger().removeHandler((Handler)testLogHandler));
    }

    public static void configureLogger() {
        TestLogLevel rootLevel = configuration.getRootLevel();
        rootLevel.setAsRootLevel();
        CONSOLE_HANDLER.adjustLevel(rootLevel);
        for (Map.Entry<String, TestLogLevel> entry : configuration.getConfiguredLogger().entrySet()) {
            entry.getValue().addLogger(entry.getKey());
        }
    }

    private static Logger getRootLogger() {
        return LogManager.getLogManager().getLogger("");
    }

    private static List<Handler> getHandler() {
        return Arrays.asList(TestLoggerFactory.getRootLogger().getHandlers());
    }

    public static TestLogHandler getTestHandler() {
        return TestLoggerFactory.getTestHandlerOption().orElseThrow(() -> new AssertionError((Object)"Unable to access de.cuioss.test.juli.TestLogHandler. Used properly?"));
    }

    public static Optional<TestLogHandler> getTestHandlerOption() {
        for (Handler handler : TestLoggerFactory.getHandler()) {
            if (!(handler instanceof TestLogHandler)) continue;
            return Optional.of((TestLogHandler)handler);
        }
        return Optional.empty();
    }

    public static void addLogger(TestLogLevel logLevel, String loggerName) {
        CONSOLE_HANDLER.adjustLevel(logLevel);
        if (MoreStrings.isEmpty((CharSequence)loggerName)) {
            Logger.getLogger("").setLevel(logLevel.getJuliLevel());
        }
        Logger.getLogger(loggerName).setLevel(logLevel.getJuliLevel());
    }

    @Generated
    private TestLoggerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

