/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.TestLogLevel;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;

class ConsoleHandlerModifier {
    private Level initialHandlerLevel;

    ConsoleHandlerModifier() {
    }

    void saveLevel() {
        Optional<ConsoleHandler> consoleHandler = ConsoleHandlerModifier.getConsoleHandler();
        consoleHandler.ifPresent(handler -> {
            this.initialHandlerLevel = handler.getLevel();
        });
    }

    void adjustLevel(TestLogLevel level) {
        Optional<ConsoleHandler> consoleHandler = ConsoleHandlerModifier.getConsoleHandler();
        if (consoleHandler.isPresent()) {
            Level current = consoleHandler.get().getLevel();
            Level newLevel = level.getJuliLevel();
            if (newLevel.intValue() < current.intValue()) {
                consoleHandler.get().setLevel(newLevel);
            }
        }
    }

    void restoreLevel() {
        Optional<ConsoleHandler> consoleHandler = ConsoleHandlerModifier.getConsoleHandler();
        if (consoleHandler.isPresent() && null != this.initialHandlerLevel && this.initialHandlerLevel.intValue() != consoleHandler.get().getLevel().intValue()) {
            consoleHandler.get().setLevel(this.initialHandlerLevel);
            this.initialHandlerLevel = null;
        }
    }

    static Optional<ConsoleHandler> getConsoleHandler() {
        for (Handler handler : LogManager.getLogManager().getLogger("").getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            ConsoleHandler consoleHandler = (ConsoleHandler)handler;
            return Optional.of(consoleHandler);
        }
        return Optional.empty();
    }
}

