/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.TestLogHandler;
import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.test.juli.TestLoggerFactory;
import java.util.List;
import java.util.logging.LogRecord;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public final class LogAsserts {
    private static final String ALL_LOGS = ", All recorded Logs:\n";
    private static final String MESSAGE_EXACTLY = " and message is exactly=";
    private static final String MESSAGE_CONTAINS = " and message containing=";
    private static final String AND_THROWABLE = " and throwable=";
    private static final String NO_LOG_MESSAGE_FOUND_WITH_LEVEL = "No log message found with level=";
    private static final String AT_LEAST_ONE_LOG_MESSAGE_FOUND_WITH_LEVEL = "At least one log message found with level=";
    private static final String NO_SINGLE_MESSAGE_FOUND_WITH_LEVEL = "Expected one message to be found with level=";

    public static void assertLogMessagePresent(TestLogLevel logLevel, String message) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessages(logLevel, message);
        String assertionMessage = NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertNotEquals((int)0, (int)messages.size(), (String)assertionMessage);
    }

    public static void assertNoLogMessagePresent(TestLogLevel logLevel, String messagePart) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessagesContaining(logLevel, messagePart);
        String assertionMessage = AT_LEAST_ONE_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + messagePart + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertTrue((boolean)messages.isEmpty(), (String)assertionMessage);
    }

    public static void assertNoLogMessagePresent(TestLogLevel logLevel, Class<?> logger) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessagesForLogger(logLevel, logger);
        String assertionMessage = AT_LEAST_ONE_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + ", on logger= " + logger + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertEquals((int)0, (int)messages.size(), (String)assertionMessage);
    }

    public static void assertSingleLogMessagePresent(TestLogLevel logLevel, String message) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessages(logLevel, message);
        String assertionMessage = NO_SINGLE_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertEquals((int)1, (int)records.size(), (String)assertionMessage);
    }

    public static void assertLogMessagePresent(TestLogLevel logLevel, String message, Throwable throwable) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessages(logLevel, message, throwable);
        String assertionMessage = NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + AND_THROWABLE + throwable + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertNotEquals((int)0, (int)messages.size(), (String)assertionMessage);
    }

    public static void assertSingleLogMessagePresent(TestLogLevel logLevel, String message, Throwable throwable) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessages(logLevel, message, throwable);
        String assertionMessage = NO_SINGLE_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + AND_THROWABLE + throwable + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertEquals((int)1, (int)records.size(), (String)assertionMessage);
    }

    public static void assertLogMessagePresent(TestLogLevel logLevel, String message, Class<? extends Throwable> throwableClass) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessages(logLevel, message, throwableClass);
        String assertionMessage = NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + AND_THROWABLE + throwableClass + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertNotEquals((int)0, (int)messages.size(), (String)assertionMessage);
    }

    public static void assertSingleLogMessagePresent(TestLogLevel logLevel, String message, Class<? extends Throwable> throwableClass) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessages(logLevel, message, throwableClass);
        String assertionMessage = NO_SINGLE_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_EXACTLY + message + AND_THROWABLE + throwableClass + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertEquals((int)1, (int)records.size(), (String)assertionMessage);
    }

    public static void assertLogMessagePresentContaining(TestLogLevel logLevel, String messagePart) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> messages = testHandler.resolveLogMessagesContaining(logLevel, messagePart);
        String assertionMessage = NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertNotEquals((int)0, (int)messages.size(), (String)assertionMessage);
    }

    public static void assertSingleLogMessagePresentContaining(TestLogLevel logLevel, String messagePart) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessagesContaining(logLevel, messagePart);
        String assertionMessage = NO_SINGLE_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + ALL_LOGS + testHandler.getRecordsAsString();
        Assertions.assertEquals((int)1, (int)records.size(), (String)assertionMessage);
    }

    public static void assertLogMessagePresentContaining(TestLogLevel logLevel, String messagePart, Throwable throwable) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessagesContaining(logLevel, messagePart, throwable);
        Assertions.assertNotEquals((int)0, (int)records.size(), (String)(NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + AND_THROWABLE + throwable + ALL_LOGS + testHandler.getRecordsAsString()));
    }

    public static void assertLogMessagePresentContaining(TestLogLevel logLevel, String messagePart, Class<? extends Throwable> throwableClass) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessagesContaining(logLevel, messagePart, throwableClass);
        Assertions.assertNotEquals((int)0, (int)records.size(), (String)(NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + AND_THROWABLE + throwableClass + ALL_LOGS + testHandler.getRecordsAsString()));
    }

    public static void assertSingleLogMessagePresentContaining(TestLogLevel logLevel, String messagePart, Throwable throwable) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessagesContaining(logLevel, messagePart, throwable);
        Assertions.assertEquals((int)1, (int)records.size(), (String)(NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + AND_THROWABLE + throwable + ALL_LOGS + testHandler.getRecordsAsString()));
    }

    public static void assertSingleLogMessagePresentContaining(TestLogLevel logLevel, String messagePart, Class<? extends Throwable> throwableClass) {
        TestLogHandler testHandler = TestLoggerFactory.getTestHandler();
        List<LogRecord> records = testHandler.resolveLogMessagesContaining(logLevel, messagePart, throwableClass);
        Assertions.assertEquals((int)1, (int)records.size(), (String)(NO_LOG_MESSAGE_FOUND_WITH_LEVEL + logLevel + MESSAGE_CONTAINS + messagePart + AND_THROWABLE + throwableClass + ALL_LOGS + testHandler.getRecordsAsString()));
    }

    @Generated
    private LogAsserts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

