/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.tools.string.MoreStrings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

final class StaticLoggerConfigurator {
    private final Map<String, String> defaultConfiguration = new ConcurrentHashMap<String, String>();

    StaticLoggerConfigurator() {
    }

    Optional<String> getStringProperty(String name) {
        if (MoreStrings.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        if (System.getProperties().containsKey(name)) {
            return Optional.of(System.getProperty(name));
        }
        if (this.defaultConfiguration.containsKey(name)) {
            return Optional.of(this.defaultConfiguration.get(name));
        }
        return Optional.empty();
    }

    Optional<Boolean> getBooleanProperty(String name) {
        Optional<String> propertyOption = this.getStringProperty(name);
        return propertyOption.map(Boolean::valueOf);
    }

    Map<String, TestLogLevel> getConfiguredLogger() {
        HashMap<String, TestLogLevel> found = new HashMap<String, TestLogLevel>();
        HashSet<String> loggerStrings = new HashSet<String>();
        for (Object name : System.getProperties().keySet()) {
            if (!StaticLoggerConfigurator.startsWith(name, "cui.logger.")) continue;
            loggerStrings.add(name.toString());
        }
        for (String config : loggerStrings) {
            found.put(config.substring("cui.logger.".length()), TestLogLevel.getLevelOrDefault(this.getStringProperty(config).get(), TestLogLevel.INFO));
        }
        return found;
    }

    TestLogLevel getRootLevel() {
        String configured = this.getStringProperty("cui.logging.root_log_level").orElse("");
        return TestLogLevel.getLevelOrDefault(configured, TestLogLevel.INFO);
    }

    static boolean startsWith(Object toBeChecked, String search) {
        if (null == toBeChecked) {
            return false;
        }
        return MoreStrings.nullToEmpty((String)toBeChecked.toString()).startsWith(MoreStrings.nullToEmpty((String)search));
    }
}

