/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.tools.string.MoreStrings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public class TestLogHandler
extends Handler {
    private static final String TEST_LOG_LEVEL_MUST_NOT_BE_NULL = "TestLogLevel must not be null";
    private static final String LOGGER_MUST_NOT_BE_NULL = "Logger must not be null";
    private static final String MESSAGE_MUST_NOT_BE_NULL = "Message must not be null";
    private static final String THROWABLE_CLASS_MUST_NOT_BE_NULL = "ThrowableClass must not be null";
    private static final String THROWABLE_MUST_NOT_BE_NULL = "Throwable must not be null";
    private final List<LogRecord> records = Collections.synchronizedList(new ArrayList());

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        this.records.add(logRecord);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public List<LogRecord> resolveLogMessages(TestLogLevel level, String message, Class<? extends Throwable> throwableClass) {
        Assertions.assertNotNull(throwableClass, (String)THROWABLE_CLASS_MUST_NOT_BE_NULL);
        return this.resolveLogMessages(level, message).stream().filter(r -> TestLogHandler.logRecordContains(r, throwableClass)).toList();
    }

    public List<LogRecord> resolveLogMessages(TestLogLevel level, String message, Throwable throwable) {
        Assertions.assertNotNull((Object)throwable, (String)THROWABLE_MUST_NOT_BE_NULL);
        return this.resolveLogMessages(level, message).stream().filter(r -> TestLogHandler.logRecordContains(r, throwable)).toList();
    }

    public List<LogRecord> resolveLogMessages(TestLogLevel level, String message) {
        Assertions.assertNotNull((Object)message, (String)MESSAGE_MUST_NOT_BE_NULL);
        return this.resolveLogMessages(level).stream().filter(r -> message.equals(r.getMessage())).toList();
    }

    public List<LogRecord> resolveLogMessagesForLogger(String logger) {
        Assertions.assertFalse((boolean)MoreStrings.isEmpty((CharSequence)logger), (String)LOGGER_MUST_NOT_BE_NULL);
        return this.records.stream().filter(r -> logger.equalsIgnoreCase(r.getLoggerName())).toList();
    }

    public List<LogRecord> resolveLogMessagesForLogger(TestLogLevel level, String logger) {
        Assertions.assertNotNull((Object)((Object)level), (String)TEST_LOG_LEVEL_MUST_NOT_BE_NULL);
        return this.resolveLogMessagesForLogger(logger).stream().filter(r -> level.getJuliLevel().equals(r.getLevel())).toList();
    }

    public List<LogRecord> resolveLogMessagesForLogger(TestLogLevel level, Class<?> logger) {
        Assertions.assertNotNull((Object)((Object)level), (String)TEST_LOG_LEVEL_MUST_NOT_BE_NULL);
        Assertions.assertNotNull(logger, (String)LOGGER_MUST_NOT_BE_NULL);
        return this.resolveLogMessagesForLogger(level, logger.getName());
    }

    public List<LogRecord> resolveLogMessagesForLogger(Class<?> logger) {
        Assertions.assertNotNull(logger, (String)LOGGER_MUST_NOT_BE_NULL);
        return this.resolveLogMessagesForLogger(logger.getName());
    }

    public List<LogRecord> resolveLogMessagesContaining(TestLogLevel level, String messagePart) {
        Assertions.assertNotNull((Object)messagePart, (String)MESSAGE_MUST_NOT_BE_NULL);
        return this.resolveLogMessages(level).stream().filter(r -> TestLogHandler.logRecordContains(r, messagePart)).toList();
    }

    public List<LogRecord> resolveLogMessagesContaining(TestLogLevel level, String messagePart, Throwable throwable) {
        Assertions.assertNotNull((Object)throwable, (String)THROWABLE_MUST_NOT_BE_NULL);
        return this.resolveLogMessagesContaining(level, messagePart).stream().filter(r -> TestLogHandler.logRecordContains(r, throwable)).toList();
    }

    public List<LogRecord> resolveLogMessagesContaining(TestLogLevel level, String messagePart, Class<? extends Throwable> throwableClass) {
        Assertions.assertNotNull(throwableClass, (String)THROWABLE_CLASS_MUST_NOT_BE_NULL);
        return this.resolveLogMessagesContaining(level, messagePart).stream().filter(r -> TestLogHandler.logRecordContains(r, throwableClass)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogRecord> resolveLogMessages(TestLogLevel level) {
        Assertions.assertNotNull((Object)((Object)level), (String)TEST_LOG_LEVEL_MUST_NOT_BE_NULL);
        List<LogRecord> list = this.records;
        synchronized (list) {
            return this.records.stream().filter(r -> TestLogHandler.logRecordContains(r, level)).toList();
        }
    }

    public void clearRecords() {
        this.records.clear();
    }

    private static boolean logRecordContains(LogRecord logRecord, String messagePart) {
        String msg = logRecord.getMessage();
        return null != msg && msg.contains(messagePart);
    }

    private static boolean logRecordContains(LogRecord logRecord, Class<? extends Throwable> throwableClass) {
        Throwable thrown = logRecord.getThrown();
        return null != thrown && thrown.getClass().equals(throwableClass);
    }

    private static boolean logRecordContains(LogRecord logRecord, Throwable throwable) {
        Throwable thrown = logRecord.getThrown();
        return null != thrown && thrown.equals(throwable);
    }

    private static boolean logRecordContains(LogRecord logRecord, TestLogLevel level) {
        Level loggedLevel = logRecord.getLevel();
        return null != loggedLevel && loggedLevel.equals(level.getJuliLevel());
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.getRecords().size() + " entries";
    }

    public String getRecordsAsString() {
        if (this.records.isEmpty()) {
            return "No log messages available";
        }
        ArrayList<LogRecord> all = new ArrayList<LogRecord>(this.records);
        all.sort(Comparator.comparing(l -> l.getLevel().intValue()));
        ArrayList elements = new ArrayList();
        all.forEach(l -> elements.add(String.valueOf((Object)TestLogLevel.parse(l.getLevel())) + ": " + l.getLoggerName() + "-" + l.getMessage()));
        StringBuilder builder = new StringBuilder();
        builder.append("Available Messages:");
        for (String element : elements) {
            builder.append("\n").append(element);
        }
        return builder.toString();
    }

    @Generated
    public List<LogRecord> getRecords() {
        return this.records;
    }
}

