/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli.junit5;

import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.test.juli.TestLoggerFactory;
import de.cuioss.test.juli.junit5.EnableTestLogger;
import de.cuioss.tools.reflect.MoreReflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestLoggerController
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback {
    public void beforeEach(ExtensionContext context) {
        TestLoggerFactory.configureLogger();
        TestLoggerFactory.getTestHandler().clearRecords();
        List<EnableTestLogger> annotations = this.collectAnnotationsFromHierarchy(context);
        for (EnableTestLogger annotation : annotations) {
            this.handleEnableTestLoggerAnnotation(annotation);
        }
    }

    public void afterAll(ExtensionContext context) {
        TestLoggerFactory.uninstall();
    }

    public void beforeAll(ExtensionContext context) {
        TestLoggerFactory.install();
    }

    private List<EnableTestLogger> collectAnnotationsFromHierarchy(ExtensionContext context) {
        ArrayList<EnableTestLogger> annotations = new ArrayList<EnableTestLogger>();
        ExtensionContext current = context;
        while (current != null) {
            current.getTestClass().ifPresent(testClass -> {
                Optional annotation = MoreReflection.extractAnnotation((Class)testClass, EnableTestLogger.class);
                annotation.ifPresent(annotations::add);
            });
            current = current.getParent().orElse(null);
        }
        Collections.reverse(annotations);
        return annotations;
    }

    private void handleEnableTestLoggerAnnotation(EnableTestLogger annotation) {
        TestLoggerFactory.addLogger(annotation.rootLevel(), "");
        for (Class<?> clazz : annotation.trace()) {
            TestLogLevel.TRACE.addLogger(clazz);
        }
        for (Class<?> clazz : annotation.debug()) {
            TestLogLevel.DEBUG.addLogger(clazz);
        }
        for (Class<?> clazz : annotation.info()) {
            TestLogLevel.INFO.addLogger(clazz);
        }
        for (Class<?> clazz : annotation.warn()) {
            TestLogLevel.WARN.addLogger(clazz);
        }
        for (Class<?> clazz : annotation.error()) {
            TestLogLevel.ERROR.addLogger(clazz);
        }
    }
}

