/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver;

import de.cuioss.test.mockwebserver.EnableMockWebServer;
import de.cuioss.test.mockwebserver.MockWebServerHolder;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import mockwebserver3.MockWebServer;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class MockWebServerExtension
implements AfterEachCallback,
BeforeEachCallback {
    private static final CuiLogger LOGGER = new CuiLogger(MockWebServerExtension.class);
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"test", "portal", "MockWebServer"});

    public void beforeEach(ExtensionContext context) throws Exception {
        MockWebServer server = new MockWebServer();
        Object testInstance = context.getRequiredTestInstance();
        List<TestClassHolder> classModel = MockWebServerExtension.extractTestClasses(testInstance);
        Optional<EnableMockWebServer> enableMockWebServerAnnotation = classModel.stream().filter(holder -> holder.getAnnotation().isPresent()).findFirst().map(holder -> holder.getAnnotation().get());
        boolean manualStart = false;
        if (enableMockWebServerAnnotation.isPresent()) {
            manualStart = enableMockWebServerAnnotation.get().manualStart();
        }
        this.setMockWebServer(testInstance, server, context);
        if (!manualStart) {
            server.start();
            LOGGER.info("Started MockWebServer at %s", new Object[]{server.url("/")});
        } else {
            LOGGER.info("Manual start requested, server not started");
        }
        MockWebServerExtension.put(server, context);
    }

    private void setMockWebServer(Object testInstance, MockWebServer mockWebServer, ExtensionContext context) {
        Optional<MockWebServerHolder> holder = this.findMockWebServerHolder(testInstance, context);
        if (holder.isPresent()) {
            holder.get().setMockWebServer(mockWebServer);
            Optional.ofNullable(holder.get().getDispatcher()).ifPresent(arg_0 -> ((MockWebServer)mockWebServer).setDispatcher(arg_0));
            LOGGER.info("Fulfilled interface contract of MockWebServerHolder on %s", new Object[]{holder.get().getClass().getName()});
        } else {
            LOGGER.warn("No instance of %s found. Is this intentional?", new Object[]{MockWebServerHolder.class.getName()});
        }
    }

    private Optional<MockWebServerHolder> findMockWebServerHolder(Object testInstance, ExtensionContext context) {
        if (testInstance instanceof MockWebServerHolder) {
            MockWebServerHolder holder = (MockWebServerHolder)testInstance;
            LOGGER.debug("Found MockWebServerHolder in test instance %s", new Object[]{holder.getClass().getName()});
            return Optional.of(holder);
        }
        Optional parentContext = context.getParent();
        while (parentContext.isPresent()) {
            Optional parentTestInstanceOptional = ((ExtensionContext)parentContext.get()).getTestInstance();
            if (parentTestInstanceOptional.isPresent()) {
                Object parentTestInstance = parentTestInstanceOptional.get();
                if (parentTestInstance instanceof MockWebServerHolder) {
                    MockWebServerHolder holder = (MockWebServerHolder)parentTestInstance;
                    LOGGER.debug("Found MockWebServerHolder in parent test instance %s", new Object[]{holder.getClass().getName()});
                    return Optional.of(holder);
                }
            } else {
                LOGGER.debug("Parent test instance is not present although context is present %s", new Object[]{((ExtensionContext)parentContext.get()).getDisplayName()});
            }
            parentContext = ((ExtensionContext)parentContext.get()).getParent();
        }
        LOGGER.debug("Found no MockWebServerHolder in test instance %s", new Object[]{testInstance.getClass().getName()});
        return Optional.empty();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Optional<MockWebServer> optionalMockWebServer = this.get(context);
        if (optionalMockWebServer.isPresent()) {
            MockWebServer server = optionalMockWebServer.get();
            if (optionalMockWebServer.get().getStarted()) {
                LOGGER.info("Shutting down MockWebServer at %s", new Object[]{server.url("/")});
                server.shutdown();
            } else {
                LOGGER.warn("Server was not started, therefore can not be shutdown");
            }
        } else {
            LOGGER.error("Server not present, therefore can not be shutdown");
        }
    }

    private static void put(MockWebServer mockWebServer, ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)MockWebServer.class.getName(), (Object)mockWebServer);
    }

    private Optional<MockWebServer> get(ExtensionContext context) {
        return Optional.ofNullable((MockWebServer)context.getStore(NAMESPACE).get((Object)MockWebServer.class.getName()));
    }

    private static List<TestClassHolder> extractTestClasses(Object testInstance) {
        List<Object> parentClassmodel = new ArrayList();
        if (null != testInstance.getClass().getEnclosingClass()) {
            parentClassmodel = MockWebServerExtension.extractTestClassesRecursive(testInstance.getClass().getEnclosingClass(), new ArrayList<TestClassHolder>());
        }
        List<TestClassHolder> model = MockWebServerExtension.extractTestClassesRecursive(testInstance.getClass(), new ArrayList<TestClassHolder>());
        parentClassmodel.addAll(model);
        LOGGER.debug("Extracted model form %s, resulting in:\n\t-%s", new Object[]{testInstance.getClass(), Joiner.on((String)"\n\t-").join(parentClassmodel)});
        return parentClassmodel;
    }

    private static List<TestClassHolder> extractTestClassesRecursive(Class<?> testClass, List<TestClassHolder> holderList) {
        LOGGER.debug("Extract TestClassHolder %s", new Object[]{testClass});
        if (Object.class.equals(testClass)) {
            LOGGER.debug("Reached java.lang.Object, returning list");
            return holderList;
        }
        LOGGER.debug("Extracting TestClassHolder for %s", new Object[]{testClass});
        holderList.add(TestClassHolder.from(testClass));
        return MockWebServerExtension.extractTestClassesRecursive(testClass.getSuperclass(), holderList);
    }

    private static class TestClassHolder {
        @NonNull
        Class<?> testInstance;
        EnableMockWebServer annotation;

        Optional<EnableMockWebServer> getAnnotation() {
            return Optional.ofNullable(this.annotation);
        }

        static TestClassHolder from(Class<?> testClass) {
            EnableMockWebServer annotation = AnnotationSupport.findAnnotation(testClass, EnableMockWebServer.class).orElse(null);
            return new TestClassHolder(testClass, annotation);
        }

        @Generated
        public TestClassHolder(@NonNull Class<?> testInstance, EnableMockWebServer annotation) {
            if (testInstance == null) {
                throw new NullPointerException("testInstance is marked non-null but is null");
            }
            this.testInstance = testInstance;
            this.annotation = annotation;
        }

        @Generated
        public String toString() {
            return "MockWebServerExtension.TestClassHolder(testInstance=" + String.valueOf(this.getTestInstance()) + ", annotation=" + String.valueOf(this.getAnnotation()) + ")";
        }

        @NonNull
        @Generated
        public Class<?> getTestInstance() {
            return this.testInstance;
        }
    }
}

