/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.dispatcher;

import de.cuioss.test.mockwebserver.dispatcher.EndpointAnswerHandler;
import de.cuioss.test.mockwebserver.dispatcher.HttpMethodMapper;
import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.tools.collect.CollectionLiterals;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import mockwebserver3.MockResponse;
import mockwebserver3.RecordedRequest;

public class BaseAllAcceptDispatcher
implements ModuleDispatcherElement {
    private final String baseUrl;
    private final EndpointAnswerHandler getResult = EndpointAnswerHandler.forPositiveGetRequest();
    private final EndpointAnswerHandler postResult = EndpointAnswerHandler.forPositivePostRequest();
    private final EndpointAnswerHandler putResult = EndpointAnswerHandler.forPositivePutRequest();
    private final EndpointAnswerHandler deleteResult = EndpointAnswerHandler.forPositiveDeleteRequest();

    public void reset() {
        this.getResult.resetToDefaultResponse();
        this.postResult.resetToDefaultResponse();
        this.putResult.resetToDefaultResponse();
        this.deleteResult.resetToDefaultResponse();
    }

    @Override
    public Optional<MockResponse> handleGet(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.getResult.respond();
    }

    @Override
    public Optional<MockResponse> handlePost(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.postResult.respond();
    }

    @Override
    public Optional<MockResponse> handleDelete(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.deleteResult.respond();
    }

    @Override
    public Optional<MockResponse> handlePut(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.putResult.respond();
    }

    public void setMethodToResult(MockResponse mockResponse, HttpMethodMapper ... mapper) {
        block6: for (HttpMethodMapper element : mapper) {
            switch (element) {
                case GET: {
                    this.getResult.setResponse(mockResponse);
                    continue block6;
                }
                case POST: {
                    this.postResult.setResponse(mockResponse);
                    continue block6;
                }
                case PUT: {
                    this.putResult.setResponse(mockResponse);
                    continue block6;
                }
                case DELETE: {
                    this.deleteResult.setResponse(mockResponse);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown method: " + Arrays.toString((Object[])mapper));
                }
            }
        }
    }

    public void setAllButGivenMethodToResult(MockResponse mockResponse, HttpMethodMapper ... mapper) {
        Set all = CollectionLiterals.mutableSet((Object[])HttpMethodMapper.values());
        all.removeAll(CollectionLiterals.mutableSortedSet((Object[])mapper));
        this.setMethodToResult(mockResponse, all.toArray(new HttpMethodMapper[0]));
    }

    @Generated
    public BaseAllAcceptDispatcher(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public EndpointAnswerHandler getGetResult() {
        return this.getResult;
    }

    @Generated
    public EndpointAnswerHandler getPostResult() {
        return this.postResult;
    }

    @Generated
    public EndpointAnswerHandler getPutResult() {
        return this.putResult;
    }

    @Generated
    public EndpointAnswerHandler getDeleteResult() {
        return this.deleteResult;
    }
}

