/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver;

import de.cuioss.test.mockwebserver.CertificateResolver;
import de.cuioss.test.mockwebserver.EnableMockWebServer;
import de.cuioss.test.mockwebserver.MockServerConfig;
import de.cuioss.test.mockwebserver.MockWebServerHolder;
import de.cuioss.test.mockwebserver.URIBuilder;
import de.cuioss.test.mockwebserver.dispatcher.DispatcherResolutionException;
import de.cuioss.test.mockwebserver.dispatcher.DispatcherResolver;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.Joiner;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockWebServer;
import okhttp3.tls.HandshakeCertificates;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class MockWebServerExtension
implements AfterEachCallback,
BeforeEachCallback,
ParameterResolver {
    private static final CuiLogger LOGGER = new CuiLogger(MockWebServerExtension.class);
    private final DispatcherResolver dispatcherResolver = new DispatcherResolver();
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MockWebServerExtension.class});
    private final Map<Class<?>, Function<MockWebServer, Object>> parameterResolvers = Map.of(MockWebServer.class, this::resolveServerParameter, URIBuilder.class, this::resolveUrlBuilderParameter);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeEach(ExtensionContext context) {
        LOGGER.debug("Setting up MockWebServer for test: %s", new Object[]{context.getDisplayName()});
        MockWebServer server = null;
        server = new MockWebServer();
        Object testInstance = context.getRequiredTestInstance();
        Optional<EnableMockWebServer> enableMockWebServerAnnotation = this.findEnableMockWebServerAnnotation(testInstance);
        MockServerConfig config = this.getConfig(enableMockWebServerAnnotation.orElse(null));
        LOGGER.debug("Using configuration: useHttps=%s, manualStart=%s", new Object[]{config.useHttps(), config.manualStart()});
        if (config.useHttps()) {
            this.configureHttps(server, context, config);
        }
        this.configureDispatcher(server, testInstance);
        this.setMockWebServer(testInstance, server, context);
        if (!config.manualStart()) {
            this.startServer(server);
        } else {
            this.ensureServerNotStarted(server);
        }
        MockWebServerExtension.put(server, context);
        server = null;
        LOGGER.debug("MockWebServer setup completed successfully");
        if (server == null) return;
        try {
            server.shutdown();
            LOGGER.info("Shutdown server due to exception during setup");
            return;
        }
        catch (IOException closeEx) {
            LOGGER.warn("Failed to shutdown server during exception handling: {}", new Object[]{closeEx.getMessage()});
        }
        return;
        catch (Exception e) {
            try {
                if (e instanceof IllegalStateException || e instanceof DispatcherResolutionException) {
                    LOGGER.error((Throwable)e, "Critical error during MockWebServer setup: %s", new Object[]{e.getMessage()});
                    throw e;
                }
                LOGGER.error((Throwable)e, "Unexpected error during MockWebServer setup", new Object[0]);
                if (server == null) return;
            }
            catch (Throwable throwable) {
                if (server == null) throw throwable;
                try {
                    server.shutdown();
                    LOGGER.info("Shutdown server due to exception during setup");
                    throw throwable;
                }
                catch (IOException closeEx) {
                    LOGGER.warn("Failed to shutdown server during exception handling: {}", new Object[]{closeEx.getMessage()});
                }
                throw throwable;
            }
            try {
                server.shutdown();
                LOGGER.info("Shutdown server due to exception during setup");
                return;
            }
            catch (IOException closeEx) {
                LOGGER.warn("Failed to shutdown server during exception handling: {}", new Object[]{closeEx.getMessage()});
            }
            return;
        }
    }

    private void startServer(MockWebServer server) {
        try {
            server.start();
            LOGGER.info("Started MockWebServer at %s", new Object[]{server.url("/")});
        }
        catch (Exception e) {
            String errorMessage = "Failed to start MockWebServer";
            LOGGER.error((Throwable)e, errorMessage, new Object[0]);
            throw new IllegalStateException(errorMessage, e);
        }
    }

    private void ensureServerNotStarted(MockWebServer server) {
        if (server.getStarted()) {
            try {
                server.shutdown();
                LOGGER.info("Shutdown server to enforce manual start configuration");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown server for manual start: {}", new Object[]{e.getMessage()});
            }
        }
        LOGGER.info("Manual start requested, server not started");
    }

    private Optional<EnableMockWebServer> findEnableMockWebServerAnnotation(Object testInstance) {
        List<Class<?>> classHierarchy = this.extractClassHierarchy(testInstance);
        return classHierarchy.stream().map(clazz -> AnnotationSupport.findAnnotation((AnnotatedElement)clazz, EnableMockWebServer.class)).flatMap(Optional::stream).findFirst();
    }

    private MockServerConfig getConfig(EnableMockWebServer enableMockWebServerAnnotation) {
        if (enableMockWebServerAnnotation == null) {
            return MockServerConfig.getDefaults();
        }
        return new MockServerConfig(enableMockWebServerAnnotation.manualStart(), enableMockWebServerAnnotation.useHttps());
    }

    private void configureHttps(MockWebServer server, ExtensionContext context, MockServerConfig config) {
        LOGGER.info("Configuring HTTPS for MockWebServer");
        CertificateResolver certificateResolver = new CertificateResolver();
        Optional<HandshakeCertificates> handshakeCertificates = certificateResolver.getHandshakeCertificates(context, config);
        if (handshakeCertificates.isPresent()) {
            try {
                server.useHttps(handshakeCertificates.get().sslSocketFactory());
                LOGGER.info("HTTPS configured for MockWebServer");
                certificateResolver.createAndStoreSSLContext(context, handshakeCertificates.get());
            }
            catch (Exception e) {
                String errorMessage = "Failed to configure HTTPS with available certificates";
                LOGGER.error((Throwable)e, errorMessage, new Object[0]);
                throw new IllegalStateException(errorMessage, e);
            }
        } else {
            String errorMessage = "Failed to configure HTTPS: No key material or HandshakeCertificates available";
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    @Deprecated(since="1.1", forRemoval=true)
    private void setMockWebServer(Object testInstance, MockWebServer mockWebServer, ExtensionContext context) {
        Optional<MockWebServerHolder> holder = this.findMockWebServerHolder(testInstance, context);
        if (holder.isPresent()) {
            holder.get().setMockWebServer(mockWebServer);
            LOGGER.info("Fulfilled interface contract of MockWebServerHolder on {}", new Object[]{holder.get().getClass().getName()});
        } else {
            LOGGER.debug("No instance of {} found. This is expected with the new annotation-based approach.", new Object[]{MockWebServerHolder.class.getName()});
        }
    }

    private void configureDispatcher(MockWebServer server, Object testInstance) {
        LOGGER.info("Configuring dispatcher for test class: {}", new Object[]{testInstance.getClass().getName()});
        Dispatcher dispatcher = this.dispatcherResolver.resolveDispatcher(testInstance.getClass(), testInstance);
        server.setDispatcher(dispatcher);
        LOGGER.info("Configured dispatcher: {}", new Object[]{dispatcher.getClass().getName()});
    }

    private Optional<MockWebServerHolder> findMockWebServerHolder(Object testInstance, ExtensionContext context) {
        if (testInstance instanceof MockWebServerHolder) {
            MockWebServerHolder holder = (MockWebServerHolder)testInstance;
            LOGGER.debug("Found MockWebServerHolder in test instance %s", new Object[]{holder.getClass().getName()});
            return Optional.of(holder);
        }
        Optional parentContext = context.getParent();
        while (parentContext.isPresent()) {
            Optional parentTestInstanceOptional = ((ExtensionContext)parentContext.get()).getTestInstance();
            if (parentTestInstanceOptional.isPresent()) {
                Object parentTestInstance = parentTestInstanceOptional.get();
                if (parentTestInstance instanceof MockWebServerHolder) {
                    MockWebServerHolder holder = (MockWebServerHolder)parentTestInstance;
                    LOGGER.debug("Found MockWebServerHolder in parent test instance %s", new Object[]{holder.getClass().getName()});
                    return Optional.of(holder);
                }
            } else {
                LOGGER.debug("Parent test instance is not present although context is present %s", new Object[]{((ExtensionContext)parentContext.get()).getDisplayName()});
            }
            parentContext = ((ExtensionContext)parentContext.get()).getParent();
        }
        LOGGER.debug("Found no MockWebServerHolder in test instance %s", new Object[]{testInstance.getClass().getName()});
        return Optional.empty();
    }

    public void afterEach(ExtensionContext context) {
        Optional<MockWebServer> optionalMockWebServer = this.get(context);
        if (optionalMockWebServer.isPresent()) {
            MockWebServer server = optionalMockWebServer.get();
            try {
                if (server.getStarted()) {
                    LOGGER.info("Shutting down MockWebServer at port %s", new Object[]{server.getPort()});
                    server.shutdown();
                    LOGGER.debug("MockWebServer successfully shut down");
                } else {
                    LOGGER.debug("Server was not started, no shutdown needed");
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to shutdown MockWebServer", (Throwable)e);
                throw new IllegalStateException("Failed to properly shutdown MockWebServer", e);
            }
            finally {
                this.remove(context);
            }
        }
    }

    private void remove(ExtensionContext context) {
        try {
            context.getStore(NAMESPACE).remove((Object)context.getRequiredTestMethod());
            LOGGER.debug("Removed MockWebServer from context");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove MockWebServer from context: {}", new Object[]{e.getMessage()});
        }
    }

    private static void put(MockWebServer mockWebServer, ExtensionContext context) {
        context.getStore(NAMESPACE).put((Object)MockWebServer.class.getName(), (Object)mockWebServer);
    }

    private Optional<MockWebServer> get(ExtensionContext context) {
        return Optional.ofNullable((MockWebServer)context.getStore(NAMESPACE).get((Object)MockWebServer.class.getName()));
    }

    private List<Class<?>> extractClassHierarchy(Object testInstance) {
        ArrayList classHierarchy = new ArrayList();
        Class<?> testClass = testInstance.getClass();
        Class<?> enclosingClass = testClass.getEnclosingClass();
        if (enclosingClass != null) {
            this.addClassHierarchy(enclosingClass, classHierarchy);
        }
        this.addClassHierarchy(testClass, classHierarchy);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extracted class hierarchy from %s, resulting in:\n\t-%s", new Object[]{testInstance.getClass().getName(), Joiner.on((String)"\n\t-").join(classHierarchy)});
        }
        return classHierarchy;
    }

    private void addClassHierarchy(Class<?> clazz, List<Class<?>> hierarchy) {
        for (Class<?> current = clazz; current != null && !Object.class.equals(current); current = current.getSuperclass()) {
            hierarchy.add(current);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean supported;
        Class<?> type = parameterContext.getParameter().getType();
        boolean bl = supported = this.parameterResolvers.containsKey(type) || SSLContext.class.equals(type);
        if (supported) {
            LOGGER.debug("Parameter type %s is supported", new Object[]{type.getName()});
        }
        return supported;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        LOGGER.debug("Resolving parameter of type %s", new Object[]{type.getName()});
        if (SSLContext.class.equals(type)) {
            return this.resolveSslContextParameter(extensionContext);
        }
        Optional<MockWebServer> server = this.get(extensionContext);
        if (server.isEmpty()) {
            String errorMessage = "No MockWebServer instance available";
            LOGGER.error(errorMessage);
            throw new ParameterResolutionException(errorMessage);
        }
        MockWebServer mockWebServer = server.get();
        Function<MockWebServer, Object> resolver = this.parameterResolvers.get(type);
        if (resolver != null) {
            return resolver.apply(mockWebServer);
        }
        String errorMessage = "Unsupported parameter type: " + type.getName();
        LOGGER.error(errorMessage);
        throw new ParameterResolutionException(errorMessage);
    }

    private MockWebServer resolveServerParameter(MockWebServer server) {
        return server;
    }

    private URIBuilder resolveUrlBuilderParameter(MockWebServer server) {
        try {
            if (server.getStarted()) {
                return URIBuilder.from(server.url("/").url());
            }
            LOGGER.debug("Creating placeholder URIBuilder for non-started server");
            return URIBuilder.placeholder();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create URIBuilder from MockWebServer URL", (Throwable)e);
            throw new ParameterResolutionException("Failed to create URIBuilder from MockWebServer URL: " + e.getMessage(), (Throwable)e);
        }
    }

    private SSLContext resolveSslContextParameter(ExtensionContext context) {
        CertificateResolver certificateResolver = new CertificateResolver();
        Optional<SSLContext> sslContext = certificateResolver.getSSLContext(context);
        if (sslContext.isEmpty()) {
            String errorMessage = "No SSLContext available. Make sure HTTPS is enabled with @EnableMockWebServer(useHttps = true)";
            LOGGER.error(errorMessage);
            throw new ParameterResolutionException(errorMessage);
        }
        return sslContext.get();
    }
}

