/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver;

import de.cuioss.tools.net.UrlHelper;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class URIBuilder {
    private final URL baseUrl;
    private final List<String> pathSegments = new ArrayList<String>();
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
    private final boolean placeholder;

    private URIBuilder(URL baseUrl) {
        this.baseUrl = baseUrl;
        this.placeholder = false;
    }

    private URIBuilder() {
        this.baseUrl = null;
        this.placeholder = true;
    }

    public static URIBuilder from(@NonNull URL baseUrl) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        return new URIBuilder(baseUrl);
    }

    public static URIBuilder from(@NonNull URI baseUri) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri is marked non-null but is null");
        }
        try {
            return new URIBuilder(baseUri.toURL());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert URI to URL: " + String.valueOf(baseUri), e);
        }
    }

    public static URIBuilder placeholder() {
        return new URIBuilder();
    }

    public URIBuilder addPathSegment(@NonNull String segment) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        String trimmedSegment = UrlHelper.removeTrailingSlashesFromUrl((String)UrlHelper.removePrecedingSlashFromPath((String)segment));
        if (!(trimmedSegment = trimmedSegment.trim()).isEmpty()) {
            this.pathSegments.add(trimmedSegment);
        }
        return this;
    }

    public URIBuilder addPathSegments(String ... segments) {
        if (segments == null) {
            throw new NullPointerException("segments is marked non-null but is null");
        }
        for (String segment : segments) {
            this.addPathSegment(segment);
        }
        return this;
    }

    public URIBuilder addQueryParameter(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.queryParameters.computeIfAbsent(name, k -> new ArrayList()).add(value);
        return this;
    }

    public List<String> getPathSegments() {
        return List.copyOf(this.pathSegments);
    }

    public Map<String, List<String>> getQueryParameters() {
        return Map.copyOf(this.queryParameters);
    }

    private void validateBuilderState(boolean forBuildAsString) {
        if (this.placeholder) {
            if (forBuildAsString) {
                throw new IllegalStateException("Cannot build URI from placeholder URIBuilder. The server must be started first, and a proper URIBuilder must be created using URIBuilder.from(server.url('/').url())");
            }
            throw new IllegalStateException("Cannot build URI from placeholder URIBuilder. The server must be started first, and a proper URIBuilder must be created using URIBuilder.from(server.url('/')).url())");
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Cannot build URI with null baseUrl. This might indicate an incorrectly initialized URIBuilder.");
        }
    }

    public URI build() {
        this.validateBuilderState(false);
        String baseUrlString = this.baseUrl.toString();
        StringBuilder uriBuilder = new StringBuilder();
        if (baseUrlString.endsWith("/")) {
            uriBuilder.append(baseUrlString, 0, baseUrlString.length() - 1);
        } else {
            uriBuilder.append(baseUrlString);
        }
        if (!this.pathSegments.isEmpty()) {
            uriBuilder.append('/').append(String.join((CharSequence)"/", this.pathSegments));
        }
        if (!this.queryParameters.isEmpty()) {
            uriBuilder.append('?');
            String queryString = this.queryParameters.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> (String)entry.getKey() + "=" + value)).collect(Collectors.joining("&"));
            uriBuilder.append(queryString);
        }
        return URI.create(uriBuilder.toString());
    }

    public String buildAsString() {
        this.validateBuilderState(true);
        return this.build().toString();
    }

    public String getPath() {
        if (this.placeholder) {
            return "/";
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Cannot access path with null baseUrl. This might indicate an incorrectly initialized URIBuilder.");
        }
        return this.baseUrl.getPath();
    }

    public String getScheme() {
        if (this.placeholder) {
            return "http";
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Cannot access scheme with null baseUrl. This might indicate an incorrectly initialized URIBuilder.");
        }
        return this.baseUrl.getProtocol();
    }

    public int getPort() {
        if (this.placeholder) {
            return -1;
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Cannot access port with null baseUrl. This might indicate an incorrectly initialized URIBuilder.");
        }
        return this.baseUrl.getPort();
    }

    public URIBuilder setPath(String path) {
        this.pathSegments.clear();
        return this.addPathSegment(path);
    }
}

