/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.dispatcher;

import de.cuioss.test.mockwebserver.MockWebServerHolder;
import de.cuioss.test.mockwebserver.dispatcher.CombinedDispatcher;
import de.cuioss.test.mockwebserver.dispatcher.DispatcherResolutionException;
import de.cuioss.test.mockwebserver.dispatcher.HttpMethodMapper;
import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcher;
import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.test.mockwebserver.mockresponse.MockResponseResolver;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import mockwebserver3.Dispatcher;
import org.junit.platform.commons.support.AnnotationSupport;

public class DispatcherResolver {
    private static final CuiLogger LOGGER = new CuiLogger(DispatcherResolver.class);
    private static final String GET_MODULE_DISPATCHER_METHOD = "getModuleDispatcher";
    private static final String EXCEPTION_DETAILS = "Exception details";

    @NonNull
    public Dispatcher resolveDispatcher(Class<?> testClass, Object testInstance) {
        Optional<Dispatcher> legacyDispatcher;
        LOGGER.info("Resolving dispatcher for test class: %s", new Object[]{testClass.getName()});
        Optional<Dispatcher> annotationDispatcher = this.resolveFromAnnotationSource(testClass);
        if (annotationDispatcher.isPresent()) {
            return annotationDispatcher.get();
        }
        List<ModuleDispatcherElement> dispatchers = this.collectDispatchers(testClass, testInstance);
        if (dispatchers.isEmpty() && (legacyDispatcher = this.resolveLegacyDispatcher(testInstance)).isPresent()) {
            return legacyDispatcher.get();
        }
        if (!dispatchers.isEmpty()) {
            return this.createCombinedDispatcher(dispatchers);
        }
        LOGGER.debug("No dispatchers found, using default API dispatcher");
        return CombinedDispatcher.createAPIDispatcher();
    }

    private Optional<Dispatcher> resolveFromAnnotationSource(Class<?> testClass) {
        Optional moduleDispatcherAnnotation = AnnotationSupport.findAnnotation(testClass, ModuleDispatcher.class);
        if (moduleDispatcherAnnotation.isEmpty()) {
            LOGGER.info("No @ModuleDispatcher annotation found on test class: %s", new Object[]{testClass.getName()});
            return Optional.empty();
        }
        LOGGER.info("Found @ModuleDispatcher annotation on test class: %s", new Object[]{testClass.getName()});
        ModuleDispatcher annotation = (ModuleDispatcher)moduleDispatcherAnnotation.get();
        Optional<ModuleDispatcherElement> dispatcher = this.resolveFromAnnotation(annotation);
        if (dispatcher.isEmpty() && !annotation.providerMethod().isEmpty()) {
            LOGGER.info("Attempting to resolve dispatcher from provider method: %s", new Object[]{annotation.providerMethod()});
            Optional<Dispatcher> directDispatcher = this.resolveDirectDispatcher(testClass, annotation.providerMethod());
            if (directDispatcher.isPresent()) {
                LOGGER.info("Successfully resolved direct dispatcher from provider method");
                return directDispatcher;
            }
            LOGGER.info("Could not resolve direct dispatcher from provider method");
        }
        return Optional.empty();
    }

    private List<ModuleDispatcherElement> collectDispatchers(Class<?> testClass, Object testInstance) {
        ArrayList<ModuleDispatcherElement> dispatchers = new ArrayList<ModuleDispatcherElement>();
        Optional moduleDispatcherAnnotation = AnnotationSupport.findAnnotation(testClass, ModuleDispatcher.class);
        moduleDispatcherAnnotation.flatMap(this::resolveFromAnnotation).ifPresent(dispatcher -> {
            LOGGER.info("Successfully resolved dispatcher from annotation");
            dispatchers.add((ModuleDispatcherElement)dispatcher);
        });
        LOGGER.info("Checking for getModuleDispatcher method in test class: %s", new Object[]{testClass.getName()});
        this.resolveFromMethod(testInstance).ifPresent(dispatcher -> {
            LOGGER.info("Successfully resolved dispatcher from getModuleDispatcher method");
            dispatchers.add((ModuleDispatcherElement)dispatcher);
        });
        List<ModuleDispatcherElement> mockResponseDispatchers = MockResponseResolver.resolveFromAnnotations(testClass);
        if (!mockResponseDispatchers.isEmpty()) {
            LOGGER.debug("Found %d @MockResponse annotations on test class: %s", new Object[]{mockResponseDispatchers.size(), testClass.getName()});
            dispatchers.addAll(mockResponseDispatchers);
        }
        return dispatchers;
    }

    private Optional<Dispatcher> resolveLegacyDispatcher(Object testInstance) {
        if (testInstance instanceof MockWebServerHolder) {
            MockWebServerHolder holder = (MockWebServerHolder)testInstance;
            LOGGER.debug("Test class implements MockWebServerHolder, checking for dispatcher");
            Dispatcher legacyDispatcher = holder.getDispatcher();
            if (legacyDispatcher != null) {
                LOGGER.debug("Using legacy dispatcher from MockWebServerHolder.getDispatcher()");
                return Optional.of(legacyDispatcher);
            }
        }
        return Optional.empty();
    }

    private Dispatcher createCombinedDispatcher(List<ModuleDispatcherElement> dispatchers) {
        this.validateDispatchers(dispatchers);
        this.logActiveDispatchers(dispatchers);
        LOGGER.debug("Creating CombinedDispatcher with %d module dispatchers", new Object[]{dispatchers.size()});
        CombinedDispatcher combinedDispatcher = new CombinedDispatcher();
        combinedDispatcher.addDispatcher(dispatchers);
        return combinedDispatcher;
    }

    private Optional<ModuleDispatcherElement> resolveFromAnnotation(ModuleDispatcher annotation) {
        if (annotation.value() != ModuleDispatcherElement.class) {
            try {
                LOGGER.debug("Creating dispatcher from class: %s", new Object[]{annotation.value().getName()});
                Constructor<? extends ModuleDispatcherElement> constructor = annotation.value().getDeclaredConstructor(new Class[0]);
                return Optional.of(constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error("Failed to instantiate dispatcher class: %s", new Object[]{e.getMessage()});
                LOGGER.debug(EXCEPTION_DETAILS, (Throwable)e);
                return Optional.empty();
            }
        }
        if (annotation.provider() != Object.class && !annotation.providerMethod().isEmpty()) {
            try {
                Object result;
                LOGGER.debug("Creating dispatcher from provider: %s.%s", new Object[]{annotation.provider().getName(), annotation.providerMethod()});
                Method providerMethod = annotation.provider().getDeclaredMethod(annotation.providerMethod(), new Class[0]);
                if (Modifier.isStatic(providerMethod.getModifiers())) {
                    result = providerMethod.invoke(null, new Object[0]);
                } else {
                    Constructor<?> constructor = annotation.provider().getDeclaredConstructor(new Class[0]);
                    Object providerInstance = constructor.newInstance(new Object[0]);
                    result = providerMethod.invoke(providerInstance, new Object[0]);
                }
                if (result instanceof ModuleDispatcherElement) {
                    ModuleDispatcherElement moduleDispatcherElement = (ModuleDispatcherElement)result;
                    return Optional.of(moduleDispatcherElement);
                }
                if (result instanceof Dispatcher) {
                    LOGGER.debug("Provider method returned a Dispatcher directly, not wrapping it");
                    return Optional.empty();
                }
                LOGGER.error("Provider method did not return a ModuleDispatcherElement or Dispatcher: %s", new Object[]{result});
                return Optional.empty();
            }
            catch (Exception e) {
                LOGGER.error("Failed to invoke provider method: %s", new Object[]{e.getMessage()});
                LOGGER.debug(EXCEPTION_DETAILS, (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<ModuleDispatcherElement> resolveFromMethod(Object testInstance) {
        LOGGER.info("Attempting to resolve dispatcher from method for class: %s", new Object[]{testInstance.getClass().getName()});
        try {
            Method method = testInstance.getClass().getDeclaredMethod(GET_MODULE_DISPATCHER_METHOD, new Class[0]);
            LOGGER.info("Found getModuleDispatcher method in test class: %s", new Object[]{testInstance.getClass().getName()});
            ModuleDispatcherElement result = this.invokeModuleDispatcherMethod(testInstance, method);
            LOGGER.info("Successfully resolved dispatcher from method");
            return Optional.of(result);
        }
        catch (NoSuchMethodException e) {
            LOGGER.info("No getModuleDispatcher method found in test class: %s", new Object[]{testInstance.getClass().getName()});
            return Optional.empty();
        }
        catch (SecurityException e) {
            LOGGER.error((Throwable)e, "Security violation accessing getModuleDispatcher method", new Object[0]);
            throw new DispatcherResolutionException("Security violation accessing getModuleDispatcher method", e);
        }
    }

    private ModuleDispatcherElement invokeModuleDispatcherMethod(Object testInstance, Method method) {
        LOGGER.info("Invoking getModuleDispatcher method on instance of class: {}", new Object[]{testInstance.getClass().getName()});
        try {
            Object result;
            if (Modifier.isPublic(method.getModifiers()) && !method.canAccess(testInstance)) {
                LOGGER.info("Making public getModuleDispatcher method accessible");
                method.setAccessible(true);
            }
            if ((result = method.invoke(testInstance, new Object[0])) == null) {
                LOGGER.error("getModuleDispatcher method returned null");
                throw new DispatcherResolutionException("getModuleDispatcher method returned null");
            }
            LOGGER.info("getModuleDispatcher method returned an object of type: {}", new Object[]{result.getClass().getName()});
            if (result instanceof ModuleDispatcherElement) {
                ModuleDispatcherElement moduleDispatcherElement = (ModuleDispatcherElement)result;
                LOGGER.info("Successfully resolved ModuleDispatcherElement with base URL: {}", new Object[]{moduleDispatcherElement.getBaseUrl()});
                LOGGER.info("ModuleDispatcherElement supports methods: {}", new Object[]{moduleDispatcherElement.supportedMethods()});
                return moduleDispatcherElement;
            }
            LOGGER.error("getModuleDispatcher method returned an object of type {} which is not a ModuleDispatcherElement", new Object[]{result.getClass().getName()});
            throw new DispatcherResolutionException("getModuleDispatcher method did not return a ModuleDispatcherElement: " + result.getClass().getName());
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Throwable)e, "Cannot access getModuleDispatcher method", new Object[0]);
            throw new DispatcherResolutionException("Cannot access getModuleDispatcher method", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getCause(), "getModuleDispatcher method threw an exception", new Object[0]);
            throw new DispatcherResolutionException("getModuleDispatcher method threw an exception", e.getCause());
        }
    }

    private void validateDispatchers(List<ModuleDispatcherElement> dispatchers) {
        HashMap<String, List> pathMethodMap = new HashMap<String, List>();
        for (ModuleDispatcherElement dispatcher : dispatchers) {
            String baseUrl = dispatcher.getBaseUrl();
            for (HttpMethodMapper method : dispatcher.supportedMethods()) {
                String key = String.valueOf((Object)method) + " " + baseUrl;
                pathMethodMap.computeIfAbsent(key, k -> new ArrayList()).add(dispatcher);
            }
        }
        List<String> conflicts = pathMethodMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> (String)entry.getKey() + " handled by " + ((List)entry.getValue()).size() + " dispatchers").toList();
        if (!conflicts.isEmpty()) {
            String errorMessage = "Dispatcher conflicts found:\n" + String.join((CharSequence)"\n", conflicts);
            LOGGER.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    private Optional<Dispatcher> resolveDirectDispatcher(Class<?> testClass, String methodName) {
        try {
            Method providerMethod = testClass.getDeclaredMethod(methodName, new Class[0]);
            Object result = providerMethod.invoke(null, new Object[0]);
            if (result instanceof Dispatcher) {
                Dispatcher directDispatcher = (Dispatcher)result;
                LOGGER.debug("Found direct Dispatcher from provider method: %s", new Object[]{methodName});
                return Optional.of(directDispatcher);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to resolve direct Dispatcher: %s", new Object[]{e.getMessage()});
        }
        return Optional.empty();
    }

    private void logActiveDispatchers(List<ModuleDispatcherElement> dispatchers) {
        if (!LOGGER.isInfoEnabled() || dispatchers.isEmpty()) {
            return;
        }
        LOGGER.info("Active dispatcher elements:");
        ArrayList<CallSite> logEntries = new ArrayList<CallSite>();
        for (ModuleDispatcherElement dispatcher : dispatchers) {
            String baseUrl = dispatcher.getBaseUrl();
            for (HttpMethodMapper method : dispatcher.supportedMethods()) {
                String dispatcherName = dispatcher.getClass().getSimpleName();
                logEntries.add((CallSite)((Object)(String.valueOf((Object)method) + " " + baseUrl + " -> " + dispatcherName)));
            }
        }
        logEntries.stream().sorted(Comparator.comparing(entry -> entry.split(" -> ")[0])).forEach(entry -> LOGGER.info("- %s", new Object[]{entry}));
    }
}

