/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.mockresponse;

import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.test.mockwebserver.mockresponse.MockResponse;
import de.cuioss.test.mockwebserver.mockresponse.MockResponseDispatcherElement;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Nested;

public final class MockResponseResolver {
    private static final CuiLogger LOGGER = new CuiLogger(MockResponseResolver.class);

    public static List<ModuleDispatcherElement> resolveFromAnnotations(@NonNull Class<?> testClass) {
        if (testClass == null) {
            throw new NullPointerException("testClass is marked non-null but is null");
        }
        ArrayList<ModuleDispatcherElement> result = new ArrayList<ModuleDispatcherElement>();
        MockResponseResolver.collectFromClass(testClass, result);
        MockResponseResolver.collectFromMethods(testClass, result);
        return result;
    }

    private static void collectFromClass(Class<?> clazz, List<ModuleDispatcherElement> result) {
        MockResponse[] annotations = (MockResponse[])clazz.getAnnotationsByType(MockResponse.class);
        for (MockResponse annotation : annotations) {
            try {
                result.add(new MockResponseDispatcherElement(annotation));
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, "Failed to create MockResponseDispatcherElement from annotation on class %s: %s", new Object[]{clazz.getName(), e.getMessage()});
            }
        }
        for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
            if (!nestedClass.isAnnotationPresent(Nested.class)) continue;
            MockResponseResolver.collectFromClass(nestedClass, result);
        }
    }

    private static void collectFromMethods(Class<?> clazz, List<ModuleDispatcherElement> result) {
        for (Method method : clazz.getDeclaredMethods()) {
            MockResponse[] annotations;
            for (MockResponse annotation : annotations = (MockResponse[])method.getAnnotationsByType(MockResponse.class)) {
                try {
                    result.add(new MockResponseDispatcherElement(annotation));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create MockResponseDispatcherElement from annotation on method %s.%s: %s", new Object[]{clazz.getName(), method.getName(), e.getMessage()});
                }
            }
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredClasses()) {
            if (!((Class)genericDeclaration).isAnnotationPresent(Nested.class)) continue;
            MockResponseResolver.collectFromMethods(genericDeclaration, result);
        }
    }

    @Generated
    private MockResponseResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

