/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver;

import de.cuioss.test.mockwebserver.MockServerConfig;
import de.cuioss.test.mockwebserver.TestProvidedCertificate;
import de.cuioss.test.mockwebserver.ssl.KeyMaterialUtil;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import okhttp3.tls.HandshakeCertificates;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ReflectionUtils;

class CertificateResolver {
    private static final CuiLogger LOGGER = new CuiLogger(CertificateResolver.class);
    private static final String DEFAULT_PROVIDER_METHOD_NAME = "provideHandshakeCertificates";
    private static final String SELF_SIGNED_CERTIFICATES_KEY = "self-signed-certificates";
    private static final String SSL_CONTEXT_KEY = "ssl-context";
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CertificateResolver.class});

    CertificateResolver() {
    }

    Optional<HandshakeCertificates> determineTestProvidedHandshakeCertificates(ExtensionContext context) {
        Optional<TestProvidedCertificate> annotation;
        Optional testClass = context.getTestClass();
        if (testClass.isEmpty()) {
            return Optional.empty();
        }
        Optional<TestProvidedCertificate> classAnnotation = Optional.ofNullable(((Class)testClass.get()).getAnnotation(TestProvidedCertificate.class));
        Optional<TestProvidedCertificate> methodAnnotation = context.getTestMethod().map(method -> method.getAnnotation(TestProvidedCertificate.class));
        Optional<TestProvidedCertificate> optional = annotation = methodAnnotation.isPresent() ? methodAnnotation : classAnnotation;
        if (annotation.isEmpty()) {
            return Optional.empty();
        }
        Class<?> providerClass = annotation.get().providerClass() != Void.class ? annotation.get().providerClass() : (Class<?>)testClass.get();
        String methodName = annotation.get().methodName();
        return this.getCertificatesFromProvider(providerClass, methodName, context);
    }

    Optional<HandshakeCertificates> getCertificatesFromProvider(Class<?> providerClass, String methodName, ExtensionContext context) {
        try {
            Object result;
            Optional method = ReflectionUtils.findMethod(providerClass, (String)methodName, (Class[])new Class[0]);
            if (method.isEmpty() && !DEFAULT_PROVIDER_METHOD_NAME.equals(methodName)) {
                method = ReflectionUtils.findMethod(providerClass, (String)DEFAULT_PROVIDER_METHOD_NAME, (Class[])new Class[0]);
            }
            if (method.isEmpty()) {
                return Optional.empty();
            }
            Object providerInstance = null;
            if (context.getTestClass().isPresent() && ((Class)context.getTestClass().get()).equals(providerClass)) {
                providerInstance = context.getTestInstance().orElse(null);
            }
            if (providerInstance == null && !ReflectionUtils.isStatic((Member)((Member)method.get()))) {
                providerInstance = this.createProviderInstance(providerClass);
            }
            if ((result = ReflectionUtils.invokeMethod((Method)((Method)method.get()), providerInstance, (Object[])new Object[0])) instanceof HandshakeCertificates) {
                HandshakeCertificates certificates = (HandshakeCertificates)result;
                return Optional.of(certificates);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error resolving HandshakeCertificates from provider " + providerClass.getName(), e);
        }
    }

    Object createProviderInstance(Class<?> providerClass) {
        try {
            return ReflectionUtils.newInstance(providerClass, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create instance of provider class " + providerClass.getName(), e);
        }
    }

    public Optional<HandshakeCertificates> getHandshakeCertificates(ExtensionContext context, MockServerConfig config) {
        Optional<HandshakeCertificates> testProvidedCertificates = this.determineTestProvidedHandshakeCertificates(context);
        if (testProvidedCertificates.isPresent()) {
            LOGGER.info("Using certificates provided by @TestProvidedCertificate");
            return testProvidedCertificates;
        }
        Optional<HandshakeCertificates> cachedCertificates = this.getSelfSignedCertificatesFromContext(context);
        if (cachedCertificates.isPresent()) {
            LOGGER.info("Reusing cached self-signed HandshakeCertificates");
            return cachedCertificates;
        }
        return this.createAndStoreSelfSignedCertificates(context, config);
    }

    Optional<HandshakeCertificates> createAndStoreSelfSignedCertificates(ExtensionContext context, MockServerConfig config) {
        try {
            HandshakeCertificates certificates = KeyMaterialUtil.createSelfSignedHandshakeCertificates(config.getCertificateDuration(), config.getKeyAlgorithm());
            this.storeSelfSignedCertificatesInContext(context, certificates);
            LOGGER.info("Generated and cached new self-signed HandshakeCertificates with algorithm %s and duration %s days", new Object[]{config.getKeyAlgorithm(), config.getCertificateDuration()});
            return Optional.of(certificates);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create self-signed certificates", (Throwable)e);
            return Optional.empty();
        }
    }

    Optional<HandshakeCertificates> getSelfSignedCertificatesFromContext(ExtensionContext context) {
        ExtensionContext rootContext = this.getRootContext(context);
        HandshakeCertificates certificates = (HandshakeCertificates)rootContext.getStore(NAMESPACE).get((Object)SELF_SIGNED_CERTIFICATES_KEY, HandshakeCertificates.class);
        if (certificates != null) {
            return Optional.of(certificates);
        }
        return Optional.empty();
    }

    void storeSelfSignedCertificatesInContext(ExtensionContext context, HandshakeCertificates certificates) {
        ExtensionContext rootContext = this.getRootContext(context);
        rootContext.getStore(NAMESPACE).put((Object)SELF_SIGNED_CERTIFICATES_KEY, (Object)certificates);
    }

    public SSLContext createAndStoreSSLContext(ExtensionContext context, HandshakeCertificates handshakeCertificates) {
        try {
            SSLContext sslContext = KeyMaterialUtil.createSslContext(handshakeCertificates);
            ExtensionContext rootContext = this.getRootContext(context);
            rootContext.getStore(NAMESPACE).put((Object)SSL_CONTEXT_KEY, (Object)sslContext);
            LOGGER.debug("Stored SSLContext for parameter resolution");
            return sslContext;
        }
        catch (Exception e) {
            String errorMessage = "Failed to create or store SSLContext";
            LOGGER.error(errorMessage, (Throwable)e);
            throw new IllegalStateException(errorMessage, e);
        }
    }

    public Optional<SSLContext> getSSLContext(ExtensionContext context) {
        ExtensionContext rootContext = this.getRootContext(context);
        return Optional.ofNullable((SSLContext)rootContext.getStore(NAMESPACE).get((Object)SSL_CONTEXT_KEY, SSLContext.class));
    }

    ExtensionContext getRootContext(ExtensionContext context) {
        ExtensionContext current = context;
        while (current.getParent().isPresent()) {
            current = (ExtensionContext)current.getParent().get();
        }
        return current;
    }
}

