/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.ssl;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.net.ssl.KeyAlgorithm;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;

public final class KeyMaterialUtil {
    private static final CuiLogger LOGGER = new CuiLogger(KeyMaterialUtil.class);
    private static final String UNABLE_TO_CREATE_SSL_CONTEXT = "Unable to create SSLContext";

    public static HandshakeCertificates createSelfSignedHandshakeCertificates(int durationDays, KeyAlgorithm keyAlgorithm) {
        LOGGER.debug("Creating self-signed HandshakeCertificates with duration %s days and algorithm %s", new Object[]{durationDays, keyAlgorithm});
        try {
            Instant now = Instant.now();
            Instant validUntil = now.plus((long)durationDays, ChronoUnit.DAYS);
            HeldCertificate heldCertificate = new HeldCertificate.Builder().commonName("MockWebServer").addSubjectAlternativeName("localhost").validityInterval(now.toEpochMilli(), validUntil.toEpochMilli()).rsa2048().build();
            return new HandshakeCertificates.Builder().heldCertificate(heldCertificate, new X509Certificate[0]).addTrustedCertificate(heldCertificate.certificate()).build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create self-signed HandshakeCertificates", e);
        }
    }

    public static HandshakeCertificates convertToHandshakeCertificates(SSLContext sslContext) {
        LOGGER.debug("Converting SSLContext to HandshakeCertificates");
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext must not be null");
        }
        try {
            Instant now = Instant.now();
            Instant validUntil = now.plus(1L, ChronoUnit.DAYS);
            HeldCertificate heldCertificate = new HeldCertificate.Builder().commonName("localhost").validityInterval(now.toEpochMilli(), validUntil.toEpochMilli()).build();
            HandshakeCertificates.Builder builder = new HandshakeCertificates.Builder().heldCertificate(heldCertificate, new X509Certificate[0]).addTrustedCertificate(heldCertificate.certificate());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager x509tm = (X509TrustManager)tm;
                for (X509Certificate cert : x509tm.getAcceptedIssuers()) {
                    builder.addTrustedCertificate(cert);
                }
                break;
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert SSLContext to HandshakeCertificates", e);
        }
    }

    public static SSLContext createSslContext(HandshakeCertificates certificates) {
        LOGGER.debug("Creating SSLContext from HandshakeCertificates");
        if (certificates == null) {
            throw new IllegalArgumentException("HandshakeCertificates must not be null");
        }
        try {
            X509TrustManager trustManager = certificates.trustManager();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(System.currentTimeMillis());
            sslContext.init(null, new TrustManager[]{trustManager}, secureRandom);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(UNABLE_TO_CREATE_SSL_CONTEXT, e);
        }
    }

    @Generated
    private KeyMaterialUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

