/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.dispatcher;

import de.cuioss.test.mockwebserver.dispatcher.BaseAllAcceptDispatcher;
import de.cuioss.test.mockwebserver.dispatcher.HttpMethodMapper;
import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockResponse;
import mockwebserver3.RecordedRequest;
import org.jetbrains.annotations.NotNull;

public class CombinedDispatcher
extends Dispatcher {
    public static final int HTTP_CODE_NOT_FOUND = 404;
    public static final int HTTP_CODE_TEAPOT = 418;
    private static final CuiLogger LOGGER = new CuiLogger(CombinedDispatcher.class);
    private boolean endWithTeapot = true;
    private final List<ModuleDispatcherElement> singleDispatcher = new ArrayList<ModuleDispatcherElement>();

    public CombinedDispatcher(ModuleDispatcherElement dispatcherElement) {
        this.singleDispatcher.add(dispatcherElement);
    }

    public CombinedDispatcher(ModuleDispatcherElement ... dispatcherElement) {
        this.singleDispatcher.addAll(CollectionLiterals.mutableList((Object[])dispatcherElement));
    }

    @NotNull
    public MockResponse dispatch(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String path = MoreStrings.nullToEmpty((String)request.getPath());
        HttpMethodMapper mapper = HttpMethodMapper.of(request);
        LOGGER.info("Processing method '%s' with path '%s'", new Object[]{mapper, path});
        ArrayList<ModuleDispatcherElement> filtered = new ArrayList<ModuleDispatcherElement>();
        for (ModuleDispatcherElement dispatcher : this.singleDispatcher) {
            if (path.startsWith(dispatcher.getBaseUrl())) {
                filtered.add(dispatcher);
                LOGGER.debug("Prefix match for path '%s' with dispatcher '%s'", new Object[]{path, dispatcher.getClass().getSimpleName()});
            }
            if (filtered.contains(dispatcher)) continue;
            LOGGER.info(dispatcher.getBaseUrl());
        }
        for (ModuleDispatcherElement moduleDispatcherElement : filtered) {
            Optional<MockResponse> result = mapper.handleMethod(moduleDispatcherElement, request);
            if (!result.isPresent()) continue;
            return result.get();
        }
        LOGGER.info("Method '%s' with path '%s' could not be processed by the configured ModuleDispatcherElements. Going to default", new Object[]{mapper, path});
        int code = 418;
        if (!this.endWithTeapot) {
            code = 404;
        }
        return new MockResponse(code);
    }

    public CombinedDispatcher endWithTeapot(boolean endWithTeapot) {
        this.endWithTeapot = endWithTeapot;
        return this;
    }

    public CombinedDispatcher addDispatcher(@NonNull ModuleDispatcherElement dispatcherElement) {
        if (dispatcherElement == null) {
            throw new NullPointerException("dispatcherElement is marked non-null but is null");
        }
        this.singleDispatcher.add(dispatcherElement);
        return this;
    }

    public CombinedDispatcher addDispatcher(@NonNull List<ModuleDispatcherElement> dispatcherElements) {
        if (dispatcherElements == null) {
            throw new NullPointerException("dispatcherElements is marked non-null but is null");
        }
        this.singleDispatcher.addAll(dispatcherElements);
        return this;
    }

    public CombinedDispatcher addDispatcher(ModuleDispatcherElement ... dispatcherElements) {
        this.singleDispatcher.addAll(CollectionLiterals.mutableList((Object[])dispatcherElements));
        return this;
    }

    public static CombinedDispatcher createAPIDispatcher() {
        return new CombinedDispatcher((ModuleDispatcherElement)new BaseAllAcceptDispatcher("/api"));
    }

    @Generated
    public CombinedDispatcher() {
    }
}

