/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.dispatcher;

import de.cuioss.test.mockwebserver.dispatcher.HttpMethodMapper;
import java.util.Optional;
import lombok.Generated;
import mockwebserver3.MockResponse;

public class EndpointAnswerHandler {
    public static final MockResponse RESPONSE_FORBIDDEN = new MockResponse(403);
    public static final MockResponse RESPONSE_UNAUTHORIZED = new MockResponse(401);
    public static final String RESPONSE_SUCCESSFUL_BODY = "HTTP test successful";
    public static final MockResponse RESPONSE_OK = new MockResponse.Builder().addHeader("Content-Type", (Object)"text/plain").body("HTTP test successful").code(200).build();
    public static final MockResponse RESPONSE_NO_CONTENT = new MockResponse(204);
    public static final MockResponse RESPONSE_NOT_FOUND = new MockResponse(404);
    public static final MockResponse RESPONSE_NOT_IMPLEMENTED = new MockResponse(501);
    public static final MockResponse RESPONSE_CREATED = new MockResponse(201);
    public static final MockResponse RESPONSE_MOVED_PERMANENTLY = new MockResponse(301);
    public static final MockResponse RESPONSE_MOVED_TEMPORARILY = new MockResponse(302);
    private MockResponse defaultResponse;
    private final HttpMethodMapper httpMethod;
    private MockResponse response;

    public EndpointAnswerHandler(MockResponse defaultResponse, HttpMethodMapper httpMethod) {
        this.httpMethod = httpMethod;
        this.defaultResponse = defaultResponse;
    }

    public Optional<MockResponse> respond() {
        return Optional.ofNullable(this.response);
    }

    public EndpointAnswerHandler resetToDefaultResponse() {
        this.response = this.defaultResponse;
        return this;
    }

    public EndpointAnswerHandler respondForbidden() {
        this.response = RESPONSE_FORBIDDEN;
        return this;
    }

    public EndpointAnswerHandler respondUnauthorized() {
        this.response = RESPONSE_UNAUTHORIZED;
        return this;
    }

    public EndpointAnswerHandler respondOk() {
        this.response = RESPONSE_OK;
        return this;
    }

    public EndpointAnswerHandler respondNoContent() {
        this.response = RESPONSE_NO_CONTENT;
        return this;
    }

    public EndpointAnswerHandler respondNotFound() {
        this.response = RESPONSE_NOT_FOUND;
        return this;
    }

    public EndpointAnswerHandler respondNotImplemented() {
        this.response = RESPONSE_NOT_IMPLEMENTED;
        return this;
    }

    public EndpointAnswerHandler respondCreated() {
        this.response = RESPONSE_CREATED;
        return this;
    }

    public EndpointAnswerHandler respondMovedPermanently() {
        this.response = RESPONSE_MOVED_PERMANENTLY;
        return this;
    }

    public EndpointAnswerHandler respondMovedTemporarily() {
        this.response = RESPONSE_MOVED_TEMPORARILY;
        return this;
    }

    public static EndpointAnswerHandler forPositiveGetRequest() {
        return new EndpointAnswerHandler(RESPONSE_OK, HttpMethodMapper.GET).resetToDefaultResponse();
    }

    public static EndpointAnswerHandler forPositivePostRequest() {
        return new EndpointAnswerHandler(RESPONSE_OK, HttpMethodMapper.POST).resetToDefaultResponse();
    }

    public static EndpointAnswerHandler forPositivePutRequest() {
        return new EndpointAnswerHandler(RESPONSE_CREATED, HttpMethodMapper.PUT).resetToDefaultResponse();
    }

    public static EndpointAnswerHandler forPositiveDeleteRequest() {
        return new EndpointAnswerHandler(RESPONSE_NO_CONTENT, HttpMethodMapper.DELETE).resetToDefaultResponse();
    }

    public static EndpointAnswerHandler noContent(HttpMethodMapper httpMethod) {
        return new EndpointAnswerHandler(null, httpMethod);
    }

    @Generated
    public MockResponse getDefaultResponse() {
        return this.defaultResponse;
    }

    @Generated
    public void setDefaultResponse(MockResponse defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    @Generated
    public HttpMethodMapper getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public MockResponse getResponse() {
        return this.response;
    }

    @Generated
    public void setResponse(MockResponse response) {
        this.response = response;
    }
}

