/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.mockresponse;

import de.cuioss.test.mockwebserver.dispatcher.HttpMethodMapper;
import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.test.mockwebserver.mockresponse.MockResponseConfig;
import de.cuioss.tools.string.MoreStrings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import mockwebserver3.MockResponse;
import mockwebserver3.RecordedRequest;

public class MockResponseConfigDispatcherElement
implements ModuleDispatcherElement {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String TEXT_PLAIN_CONTENT_TYPE = "text/plain";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final String baseUrl;
    private final HttpMethodMapper method;
    private final String responseBody;
    private final int statusCode;
    private final Map<String, String> headers;

    public MockResponseConfigDispatcherElement(@NonNull MockResponseConfig annotation) {
        if (annotation == null) {
            throw new NullPointerException("annotation is marked non-null but is null");
        }
        this.baseUrl = annotation.path();
        this.method = annotation.method();
        this.statusCode = annotation.status();
        this.headers = this.parseHeaders(annotation);
        this.responseBody = this.determineResponseBody(annotation);
    }

    @Override
    public Optional<MockResponse> handleGet(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.method == HttpMethodMapper.GET) {
            return this.createResponse();
        }
        return Optional.empty();
    }

    @Override
    public Optional<MockResponse> handlePost(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.method == HttpMethodMapper.POST) {
            return this.createResponse();
        }
        return Optional.empty();
    }

    @Override
    public Optional<MockResponse> handlePut(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.method == HttpMethodMapper.PUT) {
            return this.createResponse();
        }
        return Optional.empty();
    }

    @Override
    public Optional<MockResponse> handleDelete(@NonNull RecordedRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (this.method == HttpMethodMapper.DELETE) {
            return this.createResponse();
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public Set<HttpMethodMapper> supportedMethods() {
        HashSet<HttpMethodMapper> methods = new HashSet<HttpMethodMapper>();
        methods.add(this.method);
        return methods;
    }

    private Optional<MockResponse> createResponse() {
        MockResponse.Builder responseBuilder = new MockResponse.Builder().code(this.statusCode);
        this.headers.forEach((arg_0, arg_1) -> ((MockResponse.Builder)responseBuilder).addHeader(arg_0, arg_1));
        if (!MoreStrings.isEmpty((CharSequence)this.responseBody)) {
            responseBuilder.body(this.responseBody);
        }
        return Optional.of(responseBuilder.build());
    }

    private Map<String, String> parseHeaders(MockResponseConfig annotation) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String header : annotation.headers()) {
            if (MoreStrings.isEmpty((CharSequence)header) || !header.contains("=")) continue;
            String[] parts = header.split("=", 2);
            headerMap.put(parts[0].trim(), parts[1].trim());
        }
        if (!MoreStrings.isEmpty((CharSequence)annotation.contentType())) {
            headerMap.put(CONTENT_TYPE_HEADER, annotation.contentType());
        }
        return headerMap;
    }

    private String determineResponseBody(MockResponseConfig annotation) {
        long contentTypeCount = Stream.of(annotation.textContent(), annotation.jsonContentKeyValue(), annotation.stringContent()).filter(content -> !MoreStrings.isEmpty((CharSequence)content)).count();
        if (contentTypeCount > 1L) {
            throw new IllegalArgumentException("Only one of textContent, jsonContentKeyValue, or stringContent can be specified");
        }
        if (!MoreStrings.isEmpty((CharSequence)annotation.textContent())) {
            this.headers.putIfAbsent(CONTENT_TYPE_HEADER, TEXT_PLAIN_CONTENT_TYPE);
            return annotation.textContent();
        }
        if (!MoreStrings.isEmpty((CharSequence)annotation.jsonContentKeyValue())) {
            this.headers.putIfAbsent(CONTENT_TYPE_HEADER, JSON_CONTENT_TYPE);
            return this.parseJsonContent(annotation.jsonContentKeyValue());
        }
        if (!MoreStrings.isEmpty((CharSequence)annotation.stringContent())) {
            return annotation.stringContent();
        }
        return "";
    }

    private String parseJsonContent(String jsonContent) {
        if (MoreStrings.isEmpty((CharSequence)jsonContent)) {
            return "{}";
        }
        if (this.isSpecialCase(jsonContent)) {
            return jsonContent;
        }
        if (this.isAlreadyValidJson(jsonContent)) {
            return jsonContent;
        }
        return this.convertKeyValuePairsToJson(jsonContent);
    }

    private boolean isSpecialCase(String content) {
        return "{}".equals(content) || "[]".equals(content);
    }

    private boolean isAlreadyValidJson(String content) {
        return content.startsWith("{") && content.endsWith("}") || content.startsWith("[") && content.endsWith("]");
    }

    private String convertKeyValuePairsToJson(String keyValueContent) {
        String[] pairs = keyValueContent.split(",");
        StringBuilder jsonBuilder = new StringBuilder("{");
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            if (!pair.contains("=")) continue;
            this.appendKeyValuePair(jsonBuilder, pair);
            if (i >= pairs.length - 1) continue;
            jsonBuilder.append(",");
        }
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    private void appendKeyValuePair(StringBuilder jsonBuilder, String pair) {
        String[] keyValue = pair.split("=", 2);
        String key = keyValue[0].trim();
        String value = keyValue[1].trim();
        jsonBuilder.append("\"").append(key).append("\":");
        this.appendFormattedValue(jsonBuilder, value);
    }

    private void appendFormattedValue(StringBuilder jsonBuilder, String value) {
        if (this.shouldBeUnquoted(value)) {
            jsonBuilder.append(value);
        } else {
            jsonBuilder.append("\"").append(value).append("\"");
        }
    }

    private boolean shouldBeUnquoted(String value) {
        return "true".equals(value) || "false".equals(value) || "null".equals(value) || value.matches("-?\\d+(\\.\\d+)?") || value.startsWith("[") && value.endsWith("]") || value.startsWith("{") && value.endsWith("}");
    }

    @Generated
    public String toString() {
        return "MockResponseConfigDispatcherElement(baseUrl=" + this.getBaseUrl() + ", method=" + String.valueOf((Object)this.method) + ", responseBody=" + this.responseBody + ", statusCode=" + this.statusCode + ", headers=" + String.valueOf(this.headers) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockResponseConfigDispatcherElement)) {
            return false;
        }
        MockResponseConfigDispatcherElement other = (MockResponseConfigDispatcherElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.statusCode != other.statusCode) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        HttpMethodMapper this$method = this.method;
        HttpMethodMapper other$method = other.method;
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$responseBody = this.responseBody;
        String other$responseBody = other.responseBody;
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MockResponseConfigDispatcherElement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.statusCode;
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        HttpMethodMapper $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $responseBody = this.responseBody;
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }
}

