/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.mockwebserver.mockresponse;

import de.cuioss.test.mockwebserver.dispatcher.ModuleDispatcherElement;
import de.cuioss.test.mockwebserver.mockresponse.MockResponseConfig;
import de.cuioss.test.mockwebserver.mockresponse.MockResponseConfigDispatcherElement;
import de.cuioss.tools.logging.CuiLogger;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Nested;

public final class MockResponseConfigResolver {
    private static final CuiLogger LOGGER = new CuiLogger(MockResponseConfigResolver.class);

    public static List<ModuleDispatcherElement> resolveFromAnnotations(@NonNull Class<?> testClass) {
        if (testClass == null) {
            throw new NullPointerException("testClass is marked non-null but is null");
        }
        return MockResponseConfigResolver.resolveFromAnnotations(testClass, null);
    }

    public static List<ModuleDispatcherElement> resolveFromAnnotations(@NonNull Class<?> testClass, Method testMethod) {
        if (testClass == null) {
            throw new NullPointerException("testClass is marked non-null but is null");
        }
        ArrayList<ModuleDispatcherElement> result = new ArrayList<ModuleDispatcherElement>();
        if (testMethod == null) {
            MockResponseConfigResolver.collectFromClass(testClass, result);
            MockResponseConfigResolver.collectFromMethods(testClass, result);
        } else {
            MockResponseConfigResolver.collectFromMethod(testMethod, result);
            Class<?> methodClass = testMethod.getDeclaringClass();
            MockResponseConfigResolver.collectFromClassHierarchy(methodClass, result);
        }
        return result;
    }

    private static void collectFromClass(Class<?> clazz, List<ModuleDispatcherElement> result) {
        MockResponseConfig[] annotations = (MockResponseConfig[])clazz.getAnnotationsByType(MockResponseConfig.class);
        for (MockResponseConfig annotation : annotations) {
            try {
                result.add(new MockResponseConfigDispatcherElement(annotation));
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, "Failed to create MockResponseConfigDispatcherElement from annotation on class %s: %s", new Object[]{clazz.getName(), e.getMessage()});
            }
        }
        for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
            if (!nestedClass.isAnnotationPresent(Nested.class)) continue;
            MockResponseConfigResolver.collectFromClass(nestedClass, result);
        }
    }

    private static void collectFromClassHierarchy(Class<?> clazz, List<ModuleDispatcherElement> result) {
        Class<?> superclass;
        MockResponseConfig[] annotations;
        for (MockResponseConfig annotation : annotations = (MockResponseConfig[])clazz.getAnnotationsByType(MockResponseConfig.class)) {
            try {
                result.add(new MockResponseConfigDispatcherElement(annotation));
                LOGGER.debug("Added MockResponseConfig from class %s for path %s", new Object[]{clazz.getName(), annotation.path()});
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, "Failed to create MockResponseConfigDispatcherElement from annotation on class %s: %s", new Object[]{clazz.getName(), e.getMessage()});
            }
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null) {
            MockResponseConfigResolver.collectFromClassHierarchy(enclosingClass, result);
        }
        if ((superclass = clazz.getSuperclass()) != null && !Object.class.equals(superclass)) {
            MockResponseConfigResolver.collectFromClassHierarchy(superclass, result);
        }
    }

    private static void collectFromMethod(Method method, List<ModuleDispatcherElement> result) {
        MockResponseConfig[] annotations;
        for (MockResponseConfig annotation : annotations = (MockResponseConfig[])method.getAnnotationsByType(MockResponseConfig.class)) {
            try {
                result.add(new MockResponseConfigDispatcherElement(annotation));
                LOGGER.debug("Added MockResponseConfig from method %s.%s for path %s", new Object[]{method.getDeclaringClass().getName(), method.getName(), annotation.path()});
            }
            catch (Exception e) {
                LOGGER.error("Failed to create MockResponseConfigDispatcherElement from annotation on method %s.%s: %s", new Object[]{method.getDeclaringClass().getName(), method.getName(), e.getMessage()});
            }
        }
    }

    private static void collectFromMethods(Class<?> clazz, List<ModuleDispatcherElement> result) {
        for (Method method : clazz.getDeclaredMethods()) {
            MockResponseConfig[] annotations;
            for (MockResponseConfig annotation : annotations = (MockResponseConfig[])method.getAnnotationsByType(MockResponseConfig.class)) {
                try {
                    result.add(new MockResponseConfigDispatcherElement(annotation));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create MockResponseConfigDispatcherElement from annotation on method %s.%s: %s", new Object[]{clazz.getName(), method.getName(), e.getMessage()});
                }
            }
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredClasses()) {
            if (!((Class)genericDeclaration).isAnnotationPresent(Nested.class)) continue;
            MockResponseConfigResolver.collectFromMethods(genericDeclaration, result);
        }
    }

    @Generated
    private MockResponseConfigResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

