/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.object.ObjectTestConfig;
import de.cuioss.test.valueobjects.api.object.ObjectTestContract;
import de.cuioss.test.valueobjects.contract.ReflectionUtil;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyMemberInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public class EqualsAndHashcodeContractImpl
implements ObjectTestContract {
    private static final Integer DEFAULT_INT_VALUE = 0;
    private static final CuiLogger log = new CuiLogger(EqualsAndHashcodeContractImpl.class);

    @Override
    public void assertContract(ParameterizedInstantiator<?> instantiator, ObjectTestConfig objectTestConfig) {
        Objects.requireNonNull(instantiator, "parameterizedInstantiator must not be null");
        StringBuilder builder = new StringBuilder("Verifying ");
        builder.append(this.getClass().getName()).append("\nWith configuration: ").append(instantiator.toString());
        log.info(builder.toString());
        Object target = instantiator.newInstanceMinimal();
        EqualsAndHashcodeContractImpl.assertBasicContractOnEquals(target);
        ReflectionUtil.assertHashCodeMethodIsOverriden(target.getClass());
        EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(target);
        if (EqualsAndHashcodeContractImpl.shouldTestPropertyContract(objectTestConfig)) {
            EqualsAndHashcodeContractImpl.executePropertyTests(instantiator, objectTestConfig);
        } else {
            log.info("Only checking basic contract of equals() and hasCode()");
        }
    }

    private static void executePropertyTests(ParameterizedInstantiator<?> instantiator, ObjectTestConfig objectTestConfig) {
        TreeSet<String> consideredAttributes = new TreeSet<String>();
        instantiator.getRuntimeProperties().getWritableProperties().stream().filter(p -> PropertyMemberInfo.DEFAULT.equals((Object)p.getPropertyMemberInfo())).forEach(p -> consideredAttributes.add(p.getName()));
        if (null != objectTestConfig) {
            if (objectTestConfig.equalsAndHashCodeOf().length > 0) {
                consideredAttributes.clear();
                consideredAttributes.addAll(Arrays.asList(objectTestConfig.equalsAndHashCodeOf()));
            } else {
                consideredAttributes.removeAll(Arrays.asList(objectTestConfig.equalsAndHashCodeExclude()));
            }
        }
        if (consideredAttributes.isEmpty()) {
            log.debug("No configured properties to be tested. Is this intentional?");
        } else {
            log.info("Configured attributes found for equalsAndHashCode-testing: " + consideredAttributes);
            EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithVariants(instantiator, consideredAttributes);
        }
    }

    private static boolean shouldTestPropertyContract(ObjectTestConfig objectTestConfig) {
        return null == objectTestConfig || !objectTestConfig.equalsAndHashCodeBasicOnly();
    }

    private static void assertEqualsAndHashCodeWithVariants(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        EqualsAndHashcodeContractImpl.assertEqualsAndHasCodeWithAllPropertiesSet(instantiator, consideredAttributes);
        EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithSkippingProperties(instantiator, consideredAttributes);
        EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithChangingProperties(instantiator, consideredAttributes);
    }

    private static void assertEqualsAndHasCodeWithAllPropertiesSet(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        ArrayList<String> actualAttributes = new ArrayList<String>(consideredAttributes);
        Set<String> requiredNames = RuntimeProperties.extractNames(instantiator.getRuntimeProperties().getRequiredProperties());
        actualAttributes.addAll(requiredNames);
        List<PropertySupport> properties = instantiator.getRuntimeProperties().getWritableAsPropertySupport(true, actualAttributes);
        Object fullObject1 = instantiator.newInstance(properties, false);
        Object fullObject2 = instantiator.newInstance(properties, false);
        Assertions.assertEquals(fullObject1, fullObject2, (String)"Objects should be equal with all properties set");
        Assertions.assertEquals(fullObject2, fullObject1, (String)"Objects should be equal with all properties set, but are not symmetric");
        EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(fullObject1);
    }

    private static void assertEqualsAndHashCodeWithSkippingProperties(ParameterizedInstantiator<?> instantiator, Set<String> consideredAttributes) {
        RuntimeProperties information = instantiator.getRuntimeProperties();
        List<PropertySupport> allWritableProperties = information.getWritableAsPropertySupport(true).stream().filter(prop -> consideredAttributes.contains(prop.getName())).collect(Collectors.toList());
        List nonDefaultProperties = allWritableProperties.stream().filter(prop -> !prop.isDefaultValue()).collect(Collectors.toList());
        List<PropertySupport> requiredProperties = nonDefaultProperties.stream().filter(PropertySupport::isRequired).collect(Collectors.toList());
        List additionalProperties = nonDefaultProperties.stream().filter(property -> !property.isRequired()).collect(Collectors.toList());
        int upperBound = Math.min(nonDefaultProperties.size(), consideredAttributes.size()) - 2;
        if (additionalProperties.isEmpty()) {
            log.info("Only required or default properties found, therefore no further testing");
        } else {
            Object minimalObject = instantiator.newInstance(requiredProperties, false);
            Object fullObject = instantiator.newInstance(allWritableProperties, false);
            ArrayList<PropertySupport> iteratingProperties = new ArrayList<PropertySupport>(requiredProperties);
            for (PropertySupport support : additionalProperties) {
                if (iteratingProperties.size() < upperBound) {
                    iteratingProperties.add(support);
                } else {
                    iteratingProperties.add(support.createCopyWithNonEqualValue());
                }
                Object iterating = instantiator.newInstance(iteratingProperties, false);
                String current = support.getName();
                EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(minimalObject, iterating, current);
                EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(fullObject, iterating, current);
                EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(iterating);
            }
            iteratingProperties = new ArrayList<PropertySupport>(requiredProperties);
            ArrayList reverseAddtionalProperties = new ArrayList(additionalProperties);
            Collections.reverse(reverseAddtionalProperties);
            for (PropertySupport support : reverseAddtionalProperties) {
                if (iteratingProperties.size() < upperBound) {
                    iteratingProperties.add(support);
                } else {
                    iteratingProperties.add(support.createCopyWithNonEqualValue());
                }
                Object iterating = instantiator.newInstance(iteratingProperties, false);
                String current = support.getName();
                EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(minimalObject, iterating, current);
                EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(fullObject, iterating, current);
                EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(iterating);
            }
        }
    }

    private static void assertEqualsAndHashCodeWithChangingProperties(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        HashMap allWritableProperties = new HashMap();
        instantiator.getRuntimeProperties().getWritableAsPropertySupport(true).forEach(p -> allWritableProperties.put(p.getName(), p));
        Object expected = instantiator.newInstance(new ArrayList<PropertySupport>(allWritableProperties.values()), false);
        for (String name : consideredAttributes) {
            HashMap<String, PropertySupport> current = new HashMap<String, PropertySupport>(allWritableProperties);
            Assertions.assertTrue((boolean)current.containsKey(name), (String)("Invalid configuration found: " + name + " not defined as property."));
            current.put(name, ((PropertySupport)current.get(name)).createCopyWithNonEqualValue());
            Object actual = instantiator.newInstance(new ArrayList<PropertySupport>(current.values()), false);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(expected, actual, name);
        }
        ArrayList<String> reverse = new ArrayList<String>(consideredAttributes);
        Collections.reverse(reverse);
        for (String name : reverse) {
            HashMap<String, PropertySupport> current = new HashMap<String, PropertySupport>(allWritableProperties);
            Assertions.assertTrue((boolean)current.containsKey(name), (String)("Invalid configuration found: " + name + " not defined as property."));
            current.put(name, ((PropertySupport)current.get(name)).createCopyWithNonEqualValue());
            Object actual = instantiator.newInstance(new ArrayList<PropertySupport>(current.values()), false);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(expected, actual, name);
        }
    }

    private static void assertEqualObjectAreNotEqual(Object expected, Object actual, String deltaPropertyName) {
        String message = "The Objects of type " + expected.getClass().getName() + " should not be equal, current property=" + deltaPropertyName;
        Assertions.assertNotEquals((Object)expected, (Object)actual, (String)message);
        Assertions.assertNotEquals((Object)actual, (Object)expected, (String)message);
    }

    public static void assertBasicContractOnEquals(Object underTest) {
        ReflectionUtil.assertEqualsMethodIsOverriden(underTest.getClass());
        String msgNotEqualsNull = "Expected result for equals(null) will be 'false'. Class was : " + underTest.getClass();
        Assertions.assertFalse((boolean)underTest.equals(null), (String)msgNotEqualsNull);
        String msgNotEqualsObject = "Expected result for equals(new Object()) will be 'false'. Class was : " + underTest.getClass();
        Assertions.assertFalse((boolean)underTest.equals(new Object()), (String)msgNotEqualsObject);
        String msgEqualsToSelf = "Expected result for equals(underTest) will be 'true'. Class was : " + underTest.getClass();
        Assertions.assertTrue((boolean)underTest.equals(underTest), (String)msgEqualsToSelf);
    }

    public static void assertBasicContractOnHashCode(Object underTest) {
        Assertions.assertNotEquals((Integer)DEFAULT_INT_VALUE, (int)underTest.hashCode(), (String)("Expected result of hashCode method is not '0'. Class was : " + underTest.getClass()));
    }
}

