/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.TestContract;
import de.cuioss.test.valueobjects.api.contracts.VerifyConstructor;
import de.cuioss.test.valueobjects.api.contracts.VerifyFactoryMethod;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.ConstructorBasedInstantiator;
import de.cuioss.test.valueobjects.objects.impl.FactoryBasedInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.test.valueobjects.util.AnnotationHelper;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.logging.CuiLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

public class ObjectCreatorContractImpl<T>
implements TestContract<T> {
    private static final CuiLogger log = new CuiLogger(ObjectCreatorContractImpl.class);
    @NonNull
    private final ParameterizedInstantiator<T> instantiator;

    @Override
    public void assertContract() {
        StringBuilder builder = new StringBuilder("Verifying ");
        builder.append(this.getClass().getName()).append("\nWith configuration: ").append(this.instantiator.toString());
        log.info(builder.toString());
        this.shouldPersistAllParameter();
        this.shouldHandleRequiredAndDefaults();
        this.shouldFailOnMissingRequiredAttributes();
    }

    private void shouldFailOnMissingRequiredAttributes() {
        RuntimeProperties information = this.getInstantiator().getRuntimeProperties();
        List<PropertySupport> required = information.getRequiredAsPropertySupport(true);
        for (PropertySupport support : required) {
            if (support.isPrimitive()) continue;
            ArrayList<PropertySupport> iterating = new ArrayList<PropertySupport>(required);
            iterating.remove(support);
            iterating.add(support.createCopy(false));
            boolean failed = false;
            try {
                this.getInstantiator().newInstance(iterating, false);
                failed = true;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            if (failed) {
                throw new AssertionError((Object)("Object Should not build due to missing required attribute " + support));
            }
        }
    }

    private void shouldHandleRequiredAndDefaults() {
        RuntimeProperties information = this.getInstantiator().getRuntimeProperties();
        List<PropertySupport> required = information.getRequiredAsPropertySupport(true);
        T instance = this.getInstantiator().newInstance(required, false);
        for (PropertySupport support : required) {
            if (!support.isReadable()) continue;
            support.assertValueSet(instance);
        }
        for (PropertySupport support : information.getDefaultAsPropertySupport(false)) {
            if (!support.isReadable()) continue;
            support.assertDefaultValue(instance);
        }
        for (PropertySupport support : information.getAdditionalAsPropertySupport(false)) {
            if (!support.isReadable() || support.isDefaultValue()) continue;
            support.assertValueSet(instance);
        }
    }

    private void shouldPersistAllParameter() {
        List<PropertySupport> properties = this.instantiator.getRuntimeProperties().getAllAsPropertySupport(true);
        T instance = this.instantiator.newInstance(properties, false);
        for (PropertySupport support : properties) {
            if (!support.isReadable()) continue;
            support.assertValueSet(instance);
        }
    }

    public static final <T> List<ObjectCreatorContractImpl<T>> createTestContracts(Class<T> beanType, Class<?> annotated, List<PropertyMetadata> initialPropertyMetadata) {
        List<PropertyMetadata> properties;
        Objects.requireNonNull(beanType, "beantype must not be null");
        Objects.requireNonNull(initialPropertyMetadata, "initialPropertyMetadata must not be null");
        CollectionBuilder builder = new CollectionBuilder();
        for (VerifyConstructor verifyConstructor : AnnotationHelper.extractConfiguredConstructorContracts(annotated)) {
            properties = AnnotationHelper.constructorConfigToPropertyMetadata(verifyConstructor, initialPropertyMetadata);
            ConstructorBasedInstantiator<T> instantiator = new ConstructorBasedInstantiator<T>(beanType, new RuntimeProperties(properties));
            builder.add(new ObjectCreatorContractImpl<T>(instantiator));
        }
        for (VerifyFactoryMethod verifyFactoryMethod : AnnotationHelper.extractConfiguredFactoryContracts(annotated)) {
            properties = AnnotationHelper.factoryConfigToPropertyMetadata(verifyFactoryMethod, initialPropertyMetadata);
            Class<Object> enclosingType = beanType;
            if (!VerifyFactoryMethod.class.equals(verifyFactoryMethod.enclosingType())) {
                enclosingType = verifyFactoryMethod.enclosingType();
            }
            FactoryBasedInstantiator<T> instantiator = new FactoryBasedInstantiator<T>(beanType, new RuntimeProperties(properties), enclosingType, verifyFactoryMethod.factoryMethodName());
            builder.add(new ObjectCreatorContractImpl<T>(instantiator));
        }
        return builder.toImmutableList();
    }

    @Generated
    public ObjectCreatorContractImpl(@NonNull ParameterizedInstantiator<T> instantiator) {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is marked non-null but is null");
        }
        this.instantiator = instantiator;
    }

    @Override
    @NonNull
    @Generated
    public ParameterizedInstantiator<T> getInstantiator() {
        return this.instantiator;
    }
}

