/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.object.ObjectTestConfig;
import de.cuioss.test.valueobjects.api.object.ObjectTestContract;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.tools.logging.CuiLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public class SerializableContractImpl
implements ObjectTestContract {
    private static final CuiLogger log = new CuiLogger(SerializableContractImpl.class);

    @Override
    public void assertContract(ParameterizedInstantiator<?> instantiator, ObjectTestConfig objectTestConfig) {
        Objects.requireNonNull(instantiator);
        StringBuilder builder = new StringBuilder("Verifying ");
        builder.append(this.getClass().getName()).append("\nWith configuration: ").append(instantiator.toString());
        log.info(builder.toString());
        boolean shouldUseEquals = SerializableContractImpl.checkForEqualsComparison(objectTestConfig);
        Object template = instantiator.newInstanceMinimal();
        Assertions.assertTrue((boolean)(template instanceof Serializable), (String)(template.getClass().getName() + " does not implement java.io.Serializable"));
        String serializationFailedMessage = template.getClass().getName() + " is not equal after serialization";
        Object serializeAndDeserialize = SerializableContractImpl.serializeAndDeserialize(template);
        if (shouldUseEquals) {
            Assertions.assertEquals(template, (Object)serializeAndDeserialize, (String)serializationFailedMessage);
        }
        if (!SerializableContractImpl.checkTestBasicOnly(objectTestConfig) && !instantiator.getRuntimeProperties().getWritableProperties().isEmpty()) {
            List<PropertyMetadata> properties = SerializableContractImpl.filterProperties(instantiator.getRuntimeProperties().getWritableProperties(), objectTestConfig);
            template = instantiator.newInstance(properties);
            serializeAndDeserialize = SerializableContractImpl.serializeAndDeserialize(template);
            if (shouldUseEquals) {
                Assertions.assertEquals(template, (Object)serializeAndDeserialize, (String)serializationFailedMessage);
            }
        }
    }

    static List<PropertyMetadata> filterProperties(List<PropertyMetadata> allProperties, ObjectTestConfig objectTestConfig) {
        if (null == objectTestConfig) {
            return allProperties;
        }
        TreeSet<String> consideredAttributes = new TreeSet<String>();
        allProperties.forEach(p -> consideredAttributes.add(p.getName()));
        if (objectTestConfig.serializableOf().length > 0) {
            consideredAttributes.clear();
            consideredAttributes.addAll(Arrays.asList(objectTestConfig.serializableOf()));
        } else {
            consideredAttributes.removeAll(Arrays.asList(objectTestConfig.serializableExclude()));
        }
        return allProperties.stream().filter(p -> consideredAttributes.contains(p.getName())).collect(Collectors.toList());
    }

    static boolean checkForEqualsComparison(ObjectTestConfig objectTestConfig) {
        return null == objectTestConfig || objectTestConfig.serializableCompareUsingEquals();
    }

    static boolean checkTestBasicOnly(ObjectTestConfig objectTestConfig) {
        return null != objectTestConfig && objectTestConfig.serializableBasicOnly();
    }

    public static final Object serializeAndDeserialize(Object object) {
        Assertions.assertNotNull((Object)object, (String)"Given Object must not be null");
        byte[] serialized = SerializableContractImpl.serializeObject(object);
        return SerializableContractImpl.deserializeObject(serialized);
    }

    public static final byte[] serializeObject(Object object) {
        Assertions.assertNotNull((Object)object, (String)"Given Object must not be null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oas = new ObjectOutputStream(baos);){
            oas.writeObject(object);
            oas.flush();
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to serialize, due to " + ExceptionHelper.extractCauseMessageFromThrowable(e)));
        }
        return baos.toByteArray();
    }

    public static final Object deserializeObject(byte[] bytes) {
        Object object;
        Assertions.assertNotNull((Object)bytes, (String)"Given byte-array must not be null");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Unable to deserialize, due to " + ExceptionHelper.extractCauseMessageFromThrowable(e)));
            }
        }
        ois.close();
        return object;
    }

    @Generated
    public SerializableContractImpl() {
    }
}

