/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.string.MoreStrings;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class JavaTypesGenerator<T> {
    private static final List<TypedGenerator<?>> GENERATORS = new ArrayList();
    public static final JavaTypesGenerator<Boolean> BOOLEANS = new JavaTypesGenerator(Generators.booleanObjects(), null);
    public static final JavaTypesGenerator<Boolean> BOOLEANS_PRIMITIVE = new JavaTypesGenerator(Generators.booleans(), Boolean.FALSE);
    public static final JavaTypesGenerator<Byte> BYTES = new JavaTypesGenerator(Generators.byteObjects(), null);
    public static final JavaTypesGenerator<Byte> BYTES_PRIMITIVE = new JavaTypesGenerator(Generators.bytes(), (byte)0);
    public static final JavaTypesGenerator<Character> CHARACTERS = new JavaTypesGenerator(Generators.characterObjects(), null);
    public static final JavaTypesGenerator<Character> CHARACTERS_PRIMITIVE = new JavaTypesGenerator(Generators.characters(), Character.valueOf('\u0000'));
    public static final JavaTypesGenerator<Class> CLASS = new JavaTypesGenerator(Generators.classTypes(), null);
    public static final JavaTypesGenerator<Double> DOUBLES = new JavaTypesGenerator(Generators.doubleObjects(), null);
    public static final JavaTypesGenerator<Double> DOUBLES_PRIMITIVE = new JavaTypesGenerator(Generators.doubles(), 0.0);
    public static final JavaTypesGenerator<Float> FLOATS = new JavaTypesGenerator(Generators.floatObjects(), null);
    public static final JavaTypesGenerator<Float> FLOATS_PRIMITIVE = new JavaTypesGenerator(Generators.floats(), Float.valueOf(0.0f));
    public static final JavaTypesGenerator<Integer> INTEGERS = new JavaTypesGenerator(Generators.integerObjects(), null);
    public static final JavaTypesGenerator<Integer> INTEGER_DAYS = new JavaTypesGenerator(Generators.integers((int)1, (int)31), null);
    public static final JavaTypesGenerator<Integer> INTEGER_MONTHS = new JavaTypesGenerator(Generators.integers((int)1, (int)12), null);
    public static final JavaTypesGenerator<Integer> INTEGER_YEARS = new JavaTypesGenerator(Generators.integers((int)1900, (int)2100), null);
    public static final JavaTypesGenerator<Integer> INTEGERS_PRIMITIVE = new JavaTypesGenerator(Generators.integers(), 0);
    public static final JavaTypesGenerator<Locale> LOCALES = new JavaTypesGenerator(Generators.locales(), null);
    public static final JavaTypesGenerator<Long> LONGS = new JavaTypesGenerator(Generators.longObjects(), null);
    public static final JavaTypesGenerator<Long> LONGS_PRIMITIVE = new JavaTypesGenerator(Generators.longs(), 0L);
    public static final JavaTypesGenerator<Number> NUMBERS = new JavaTypesGenerator(Generators.numbers(), null);
    public static final JavaTypesGenerator<RuntimeException> RUNTIME_EXCEPTIONS = new JavaTypesGenerator(Generators.runtimeExceptions(), null);
    public static final JavaTypesGenerator<Serializable> SERIALIZABLES = new JavaTypesGenerator(Generators.serializables(), null);
    public static final JavaTypesGenerator<Short> SHORTS = new JavaTypesGenerator(Generators.shortObjects(), null);
    public static final JavaTypesGenerator<Short> SHORTS_PRIMITIVE = new JavaTypesGenerator(Generators.shorts(), (short)0);
    public static final JavaTypesGenerator<String> STRINGS = new JavaTypesGenerator(Generators.nonEmptyStrings(), null);
    public static final JavaTypesGenerator<String> STRINGS_LETTER = new JavaTypesGenerator(Generators.letterStrings(), null);
    public static final JavaTypesGenerator<Throwable> THROWABLES = new JavaTypesGenerator(Generators.throwables(), null);
    public static final JavaTypesGenerator<TimeZone> TIME_ZONES = new JavaTypesGenerator(Generators.timeZones(), null);
    public static final JavaTypesGenerator<LocalDate> LOCAL_DATES = new JavaTypesGenerator(Generators.localDates(), null);
    public static final JavaTypesGenerator<LocalTime> LOCAL_TIMES = new JavaTypesGenerator(Generators.localTimes(), null);
    public static final JavaTypesGenerator<LocalDateTime> LOCAL_DATE_TIMES = new JavaTypesGenerator(Generators.localDateTimes(), null);
    public static final JavaTypesGenerator<Date> DATE = new JavaTypesGenerator(Generators.dates(), null);
    public static final JavaTypesGenerator<Temporal> TEMPORAL = new JavaTypesGenerator(Generators.temporals(), null);
    public static final JavaTypesGenerator<URL> URLS = new JavaTypesGenerator(Generators.urls(), null);
    public static final JavaTypesGenerator<ZoneId> ZONE_IDS = new JavaTypesGenerator(Generators.zoneIds(), null);
    public static final JavaTypesGenerator<ZoneOffset> ZONE_OFFSETS = new JavaTypesGenerator(Generators.zoneOffsets(), null);
    public static final JavaTypesGenerator<ZonedDateTime> ZONED_DATE_TIME = new JavaTypesGenerator(Generators.zonedDateTimes(), null);
    private final Class<T> propertyType;
    private final TypedGenerator<T> generator;
    private final Object defaultValue;

    private JavaTypesGenerator(TypedGenerator<T> typedGenerator, Object defaultValue) {
        this.propertyType = typedGenerator.getType();
        this.generator = typedGenerator;
        this.defaultValue = defaultValue;
        GENERATORS.add(typedGenerator);
    }

    public static List<TypedGenerator<?>> allGenerators() {
        return CollectionLiterals.immutableList(GENERATORS);
    }

    public PropertyMetadata metadata(String name) {
        return this.metadataBuilder(name).build();
    }

    public PropertyMetadata metadataRequired(String name) {
        return this.metadataBuilder(name).required(true).build();
    }

    public PropertyMetadata metadataRequired(String name, CollectionType collectionType) {
        return this.metadataBuilder(name).required(true).collectionType(collectionType).build();
    }

    public PropertyMetadata metadata(String name, CollectionType collectionType) {
        return this.metadataBuilder(name).collectionType(collectionType).build();
    }

    public PropertyMetadataImpl.PropertyMetadataBuilder metadataBuilder(String name) {
        Preconditions.checkArgument((!MoreStrings.nullToEmpty((String)name).isEmpty() ? 1 : 0) != 0, (String)"name must not be null nor empty");
        return PropertyMetadataImpl.builder().name(name).generator(this.generator).defaultValue(this.defaultValue != null).propertyClass(this.propertyType);
    }
}

