/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.junit5.extension;

import de.cuioss.test.valueobjects.generator.TypedGeneratorRegistry;
import de.cuioss.test.valueobjects.util.GeneratorAnnotationHelper;
import de.cuioss.test.valueobjects.util.GeneratorRegistry;
import java.util.Collections;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class GeneratorRegistryController
implements TestInstancePostProcessor,
AfterAllCallback {
    private static final Logger log = LoggerFactory.getLogger(GeneratorRegistryController.class);

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.debug(() -> "Clearing TypedGeneratorRegistry registry");
        TypedGeneratorRegistry.clear();
        if (testInstance instanceof GeneratorRegistry) {
            log.debug(() -> "Test-class '" + testInstance.getClass() + "' is of type de.cuioss.test.valueobjects.util.GeneratorRegistry, initializing Generator framework");
            GeneratorRegistry registry = (GeneratorRegistry)testInstance;
            GeneratorAnnotationHelper.handleGeneratorsForTestClass(registry, registry.registerAdditionalGenerators());
        } else {
            log.debug(() -> "Test-class '{" + testInstance.getClass() + "}' is NOT of type de.cuioss.test.valueobjects.util.GeneratorRegistry, initializing Generator framework without local Generator");
            GeneratorAnnotationHelper.handleGeneratorsForTestClass(testInstance, Collections.emptyList());
        }
    }

    public void afterAll(ExtensionContext context) {
        log.debug(() -> "Tearing down TypedGeneratorRegistry registry");
        TypedGeneratorRegistry.clear();
    }
}

