/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.ObjectInstantiator;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.logging.CuiLogger;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class BeanInstantiator<T>
implements ParameterizedInstantiator<T> {
    private static final CuiLogger log = new CuiLogger(BeanInstantiator.class);
    @NonNull
    private final ObjectInstantiator<T> instantiator;
    @NonNull
    private final RuntimeProperties runtimeProperties;

    @Override
    public T newInstance(List<PropertySupport> properties, boolean generatePropertyValues) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        T instance = this.instantiator.newInstance();
        if (generatePropertyValues) {
            properties.forEach(PropertySupport::generateTestValue);
        }
        for (PropertySupport propertySupport : properties) {
            if (!propertySupport.getPropertyMetadata().getPropertyReadWrite().isWriteable()) {
                log.warn("Trying to apply a property '{}' which is not writable. Please check usage and configuration of @VerifyBeanProperty, maybe add the property to 'exclude' list.", new Object[]{propertySupport.getName()});
            }
            propertySupport.apply(instance);
        }
        return instance;
    }

    @Override
    public T newInstance(List<PropertyMetadata> properties) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        return this.newInstance(properties.stream().map(PropertySupport::new).collect(Collectors.toList()), true);
    }

    @Override
    public T newInstanceMinimal() {
        return this.newInstance(this.runtimeProperties.getRequiredProperties());
    }

    @Override
    public T newInstanceFull() {
        return this.newInstance(this.runtimeProperties.getAdditionalProperties());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("\nProperty Configuration: ").append(this.runtimeProperties.toString());
        return builder.toString();
    }

    @Generated
    public BeanInstantiator(@NonNull ObjectInstantiator<T> instantiator, @NonNull RuntimeProperties runtimeProperties) {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is marked non-null but is null");
        }
        if (runtimeProperties == null) {
            throw new NullPointerException("runtimeProperties is marked non-null but is null");
        }
        this.instantiator = instantiator;
        this.runtimeProperties = runtimeProperties;
    }

    @Override
    @NonNull
    @Generated
    public RuntimeProperties getRuntimeProperties() {
        return this.runtimeProperties;
    }
}

