/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.ConfigurationCallBackHandler;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.TestObjectProvider;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class InjectedBeanInstantiator<T>
implements ParameterizedInstantiator<T> {
    private final TestObjectProvider<T> objectProvider;
    private final ConfigurationCallBackHandler<T> callbackHandler;
    @NonNull
    private final RuntimeProperties runtimeProperties;

    @Override
    public T newInstance(List<PropertySupport> properties, boolean generatePropertyValues) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        T instance = this.objectProvider.getUnderTest();
        Assertions.assertNotNull(instance, (String)("Unable to obtain instance from " + this.objectProvider.toString()));
        if (generatePropertyValues) {
            properties.forEach(PropertySupport::generateTestValue);
        }
        for (PropertySupport propertySupport : properties) {
            propertySupport.apply(instance);
        }
        this.callbackHandler.configure(instance);
        return instance;
    }

    @Override
    public T newInstanceFull() {
        return this.newInstance(this.runtimeProperties.getAdditionalProperties());
    }

    @Override
    public T newInstance(List<PropertyMetadata> properties) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        return this.newInstance(properties.stream().map(PropertySupport::new).collect(Collectors.toList()), true);
    }

    @Override
    public T newInstanceMinimal() {
        return this.newInstance(this.runtimeProperties.getRequiredProperties());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("\nProperty Configuration: ").append(this.runtimeProperties.toString());
        return builder.toString();
    }

    @Generated
    public InjectedBeanInstantiator(TestObjectProvider<T> objectProvider, ConfigurationCallBackHandler<T> callbackHandler, @NonNull RuntimeProperties runtimeProperties) {
        if (runtimeProperties == null) {
            throw new NullPointerException("runtimeProperties is marked non-null but is null");
        }
        this.objectProvider = objectProvider;
        this.callbackHandler = callbackHandler;
        this.runtimeProperties = runtimeProperties;
    }

    @Override
    @NonNull
    @Generated
    public RuntimeProperties getRuntimeProperties() {
        return this.runtimeProperties;
    }
}

