/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.property.util;

import java.util.Collection;
import lombok.Generated;

public final class CollectionAsserts {
    private static final String NOT_EQUAL = "The given object for property %s are not equal: expected=%s , actual=%s";
    private static final String NO_COLLECTION = "The given objects for property %s are to be at least a Collection: expected=%s , actual=%s";
    private static final String DIFFERENT_SIZES = "The given objects for property %s do not have the same size: expected=%s , actual=%s";

    public static void assertListsAreEqualIgnoringOrder(String propertyName, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        if (expected == null || actual == null) {
            CollectionAsserts.fail(NOT_EQUAL, propertyName, expected, actual);
        } else {
            if (!(expected instanceof Iterable) || !(actual instanceof Iterable)) {
                CollectionAsserts.fail(NO_COLLECTION, propertyName, expected, actual);
            }
            CollectionAsserts.handleAssert(propertyName, expected, actual);
        }
    }

    private static void handleAssert(String propertyName, Object expected, Object actual) {
        Collection expectedIterable = (Collection)expected;
        Collection actualIterable = (Collection)actual;
        if (expectedIterable.size() != actualIterable.size()) {
            CollectionAsserts.fail(DIFFERENT_SIZES, propertyName, expected, actual);
        }
        if (expectedIterable.isEmpty()) {
            return;
        }
        for (Object object : expectedIterable) {
            if (actualIterable.contains(object)) continue;
            CollectionAsserts.fail(NOT_EQUAL, propertyName, expected, actual);
        }
        for (Object object : actualIterable) {
            if (expectedIterable.contains(object)) continue;
            CollectionAsserts.fail(NOT_EQUAL, propertyName, expected, actual);
        }
    }

    private static void fail(String template, String propertyName, Object expected, Object actual) {
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        throw new AssertionError((Object)String.format(template, propertyName, expectedString, actualString));
    }

    @Generated
    private CollectionAsserts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

