/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.api.generator.PropertyGenerator;
import de.cuioss.test.valueobjects.api.generator.PropertyGeneratorHint;
import de.cuioss.test.valueobjects.api.generator.PropertyGeneratorHints;
import de.cuioss.test.valueobjects.api.generator.PropertyGenerators;
import de.cuioss.test.valueobjects.generator.TypedGeneratorRegistry;
import de.cuioss.test.valueobjects.generator.dynamic.GeneratorResolver;
import de.cuioss.test.valueobjects.objects.impl.DefaultInstantiator;
import de.cuioss.test.valueobjects.util.WildcardDecoratorGenerator;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.reflect.MoreReflection;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public final class GeneratorAnnotationHelper {
    public static final String UNABLE_TO_INSTANTIATE_GENERATOR = "Unable to instantiate generator, You must provide a no-arg public constructor: ";

    public static void handleGeneratorsForTestClass(Object testClass, List<TypedGenerator<?>> additionalGenerator) {
        Objects.requireNonNull(testClass);
        TypedGeneratorRegistry.registerBasicTypes();
        GeneratorAnnotationHelper.handleUnitClassImplementation(testClass);
        GeneratorAnnotationHelper.handlePropertyGenerator(testClass.getClass());
        GeneratorAnnotationHelper.handleGeneratorHints(testClass.getClass());
        if (null != additionalGenerator) {
            for (TypedGenerator<?> additional : additionalGenerator) {
                TypedGeneratorRegistry.registerGenerator(additional);
            }
        }
    }

    public static void handleGeneratorHints(Class<?> annotated) {
        for (PropertyGeneratorHint hint : GeneratorAnnotationHelper.extractConfiguredGeneratorHints(annotated)) {
            TypedGenerator<?> resolved = GeneratorResolver.resolveGenerator(hint.implementationType());
            TypedGeneratorRegistry.registerTypedGenerator(hint.declaredType(), new WildcardDecoratorGenerator(hint.declaredType(), resolved));
        }
    }

    public static void handlePropertyGenerator(Class<?> annotated) {
        for (PropertyGenerator config : GeneratorAnnotationHelper.extractConfiguredPropertyGenerator(annotated)) {
            for (Class<? extends TypedGenerator<?>> typedClass : config.value()) {
                TypedGeneratorRegistry.registerGenerator(new DefaultInstantiator(typedClass).newInstance());
            }
        }
    }

    public static void handleUnitClassImplementation(Object testClass) {
        if (testClass instanceof TypedGenerator) {
            TypedGeneratorRegistry.registerGenerator((TypedGenerator)testClass);
        }
    }

    public static Set<PropertyGeneratorHint> extractConfiguredGeneratorHints(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, PropertyGeneratorHints.class).forEach(contract -> builder.add(Arrays.asList(contract.value())));
        MoreReflection.extractAllAnnotations(annotated, PropertyGeneratorHint.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    public static Set<PropertyGenerator> extractConfiguredPropertyGenerator(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, PropertyGenerators.class).forEach(contract -> builder.add(Arrays.asList(contract.value())));
        MoreReflection.extractAllAnnotations(annotated, PropertyGenerator.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    @Generated
    private GeneratorAnnotationHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

