/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.BuilderInstantiator;
import de.cuioss.test.valueobjects.objects.ObjectInstantiator;
import de.cuioss.test.valueobjects.objects.impl.DefaultInstantiator;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;

public class BuilderConstructorBasedInstantiator<T>
implements BuilderInstantiator<T> {
    private final Method builderMethod;
    private final Class<T> targetClass;
    private final Class<?> builderClass;
    private final ObjectInstantiator<?> builderInstantiator;

    public BuilderConstructorBasedInstantiator(Class<?> builderType) {
        this(builderType, "build");
    }

    public BuilderConstructorBasedInstantiator(Class<?> builderType, String buildMethodName) {
        Objects.requireNonNull(builderType, "builderType must not be null");
        Objects.requireNonNull(MoreStrings.emptyToNull((String)buildMethodName), "builderMethodName must not be null");
        this.builderClass = builderType;
        this.builderInstantiator = new DefaultInstantiator(builderType);
        try {
            this.builderMethod = this.builderInstantiator.getTargetClass().getDeclaredMethod(buildMethodName, new Class[0]);
            this.targetClass = this.builderMethod.getReturnType();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError("Unable to access method " + buildMethodName + " on type " + builderType.getName() + ", due to " + ExceptionHelper.extractCauseMessageFromThrowable(e), e);
        }
    }

    @Override
    public Object newBuilderInstance() {
        return this.builderInstantiator.newInstance();
    }

    @Override
    public T build(Object builder) {
        try {
            return (T)this.builderMethod.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
            throw new AssertionError("Unable to access method " + this.builderMethod.getName() + " on type " + this.getBuilderClass().getName() + ", due to " + ExceptionHelper.extractCauseMessageFromThrowable(e), e);
        }
    }

    @Generated
    public String toString() {
        return "BuilderConstructorBasedInstantiator(builderMethod=" + this.builderMethod + ", targetClass=" + this.getTargetClass() + ", builderClass=" + this.getBuilderClass() + ", builderInstantiator=" + this.builderInstantiator + ")";
    }

    @Override
    @Generated
    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    @Override
    @Generated
    public Class<?> getBuilderClass() {
        return this.builderClass;
    }
}

