/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.AbstractOrderedArgsInstantiator;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;

public class FactoryBasedInstantiator<T>
extends AbstractOrderedArgsInstantiator<T> {
    private static final CuiLogger log = new CuiLogger(FactoryBasedInstantiator.class);
    private final Method factoryMethod;

    public FactoryBasedInstantiator(Class<T> type, RuntimeProperties runtimeProperties, Class<?> enclosingType, String factoryMethodName) {
        super(runtimeProperties);
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(enclosingType, "enclosingType must not be null");
        Objects.requireNonNull(factoryMethodName);
        Preconditions.checkArgument((!MoreStrings.isEmpty((CharSequence)factoryMethodName) ? 1 : 0) != 0, (String)"factoryMethodName msut not be null nor empty");
        ArrayList parameter = new ArrayList();
        runtimeProperties.getAllProperties().forEach(meta -> parameter.add(meta.resolveActualClass()));
        try {
            this.factoryMethod = parameter.isEmpty() ? enclosingType.getDeclaredMethod(factoryMethodName, new Class[0]) : enclosingType.getDeclaredMethod(factoryMethodName, FactoryBasedInstantiator.toClassArray(parameter));
            Assertions.assertNotNull((Object)this.factoryMethod, (String)("Unable to find a factory method with signature " + parameter + " and name " + factoryMethodName));
            Assertions.assertTrue((boolean)type.isAssignableFrom(this.factoryMethod.getReturnType()), (String)("Invalid type found on factory method: " + this.factoryMethod.getReturnType()));
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = "Unable to find a constructor with signature " + parameter;
            log.error(message, (Throwable)e);
            throw new AssertionError((Object)message);
        }
    }

    @Override
    protected T doInstantiate(Object ... args) {
        try {
            return (T)this.factoryMethod.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String message = "Unable to invoke constructor " + ", due to " + ExceptionHelper.extractCauseMessageFromThrowable(e);
            throw new AssertionError(message, e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("\nFactory Method: ").append(this.factoryMethod);
        builder.append("\nProperty Configuration: ").append(this.getRuntimeProperties().toString());
        return builder.toString();
    }
}

