/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract.support;

import de.cuioss.test.valueobjects.contract.support.MappingAssertStrategy;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.tools.string.Splitter;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class MappingTuple {
    private final String source;
    private final String target;
    private final MappingAssertStrategy strategy;

    public MappingTuple(String mapping, @NonNull MappingAssertStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        Assertions.assertNotNull((Object)MoreStrings.emptyToNull((String)mapping), (String)"Mapping must not be null");
        List splitted = Splitter.on((char)':').splitToList(mapping);
        Assertions.assertEquals((int)2, (int)splitted.size(), (String)("Expected a String in the form of 'source:target' but was: " + mapping));
        this.source = (String)splitted.get(0);
        this.target = (String)splitted.get(1);
        this.strategy = strategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingTuple)) {
            return false;
        }
        MappingTuple other = (MappingTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        MappingAssertStrategy this$strategy = this.getStrategy();
        MappingAssertStrategy other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MappingTuple;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        MappingAssertStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MappingTuple(source=" + this.getSource() + ", target=" + this.getTarget() + ", strategy=" + this.getStrategy() + ")";
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public MappingAssertStrategy getStrategy() {
        return this.strategy;
    }
}

