/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator.dynamic;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.generator.TypedGeneratorRegistry;
import de.cuioss.test.valueobjects.generator.dynamic.impl.ArraysGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.CollectionTypeGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.ConstructorBasedGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.DynamicProxyGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.EmptyMapGenerator;
import de.cuioss.test.valueobjects.generator.dynamic.impl.InterfaceProxyGenerator;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.tools.logging.CuiLogger;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class GeneratorResolver {
    private static final String FOUND_GENERATOR_FOR_TYPE = "Found generator {} for type {}";
    private static final String TYPE_MUST_NOT_BE_NULL = "type must not be null";
    private static final CuiLogger log = new CuiLogger(GeneratorResolver.class);

    public static <T> TypedGenerator<T> resolveGenerator(Class<T> type) {
        Objects.requireNonNull(type, TYPE_MUST_NOT_BE_NULL);
        log.debug("resolving generator for {}", new Object[]{type.getName()});
        Optional<Object> found = TypedGeneratorRegistry.getGenerator(type);
        if (found.isPresent()) {
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{((TypedGenerator)found.get()).getClass().getName(), type.getName()});
            return found.get();
        }
        found = Generators.enumValuesIfAvailable(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator((TypedGenerator)found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        found = ArraysGenerator.getGeneratorForType(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator(found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        found = GeneratorResolver.resolveCollectionGenerator(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator(found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        found = ConstructorBasedGenerator.getGeneratorForType(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator(found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        return GeneratorResolver.resolveProxyGenerator(type);
    }

    private static <T> TypedGenerator<T> resolveProxyGenerator(Class<T> type) {
        log.debug("resolveProxyGenerator for type {}", new Object[]{type.getName()});
        Optional<Object> found = InterfaceProxyGenerator.getGeneratorForType(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator(found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        found = DynamicProxyGenerator.getGeneratorForType(type);
        if (found.isPresent()) {
            TypedGeneratorRegistry.registerGenerator(found.get());
            log.trace(FOUND_GENERATOR_FOR_TYPE, new Object[]{found.get().getClass().getName(), type.getName()});
            return found.get();
        }
        throw new IllegalArgumentException("Unable to determine generator for type=" + type);
    }

    public static <T> Optional<TypedGenerator<T>> resolveCollectionGenerator(Class<T> type) {
        if (null == type || !type.isInterface()) {
            return Optional.empty();
        }
        Optional<CollectionType> optional = CollectionType.findResponsibleCollectionType(type);
        if (optional.isPresent()) {
            return Optional.of(new CollectionTypeGenerator<T>(type, optional.get()));
        }
        if (Map.class.isAssignableFrom(type)) {
            return Optional.of(new EmptyMapGenerator());
        }
        return Optional.empty();
    }

    @Generated
    private GeneratorResolver() {
    }
}

