/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects.impl;

import de.cuioss.test.valueobjects.objects.BuilderInstantiator;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;

public class BuilderParameterizedInstantiator<T>
implements ParameterizedInstantiator<T> {
    @NonNull
    private final BuilderInstantiator<T> instantiator;
    @NonNull
    private final RuntimeProperties runtimeProperties;

    @Override
    public T newInstance(List<PropertySupport> properties, boolean generatePropertyValues) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        Object builder = this.instantiator.newBuilderInstance();
        if (generatePropertyValues) {
            properties.forEach(PropertySupport::generateTestValue);
        }
        for (PropertySupport propertySupport : properties) {
            propertySupport.apply(builder);
        }
        return this.instantiator.build(builder);
    }

    @Override
    public T newInstance(List<PropertyMetadata> properties) {
        Assertions.assertNotNull(properties, (String)"Properties must not be null, but may be empty");
        return this.newInstance(properties.stream().map(PropertySupport::new).toList(), true);
    }

    @Override
    public T newInstanceMinimal() {
        return this.newInstance(this.runtimeProperties.getRequiredProperties());
    }

    @Override
    public T newInstanceFull() {
        return this.newInstance(this.runtimeProperties.getAllProperties());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("\nInstantiator: ").append(this.instantiator).append(this.runtimeProperties.toString());
        return builder.toString();
    }

    @Generated
    public BuilderParameterizedInstantiator(@NonNull BuilderInstantiator<T> instantiator, @NonNull RuntimeProperties runtimeProperties) {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is marked non-null but is null");
        }
        if (runtimeProperties == null) {
            throw new NullPointerException("runtimeProperties is marked non-null but is null");
        }
        this.instantiator = instantiator;
        this.runtimeProperties = runtimeProperties;
    }

    @Override
    @NonNull
    @Generated
    public RuntimeProperties getRuntimeProperties() {
        return this.runtimeProperties;
    }
}

