/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.property.util;

import de.cuioss.test.generator.impl.CollectionGenerator;
import de.cuioss.tools.collect.CollectionLiterals;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CollectionType {
    COLLECTION(Collection.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            return collectionGenerator.list();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            return CollectionLiterals.mutableList(iterable);
        }

        @Override
        public Iterable<?> emptyCollection() {
            return CollectionLiterals.immutableList();
        }
    }
    ,
    LIST(List.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            return collectionGenerator.list();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            return CollectionLiterals.mutableList(iterable);
        }

        @Override
        public Iterable<?> emptyCollection() {
            return CollectionLiterals.immutableList();
        }
    }
    ,
    SET(Set.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            return collectionGenerator.set();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            return CollectionLiterals.mutableSet(iterable);
        }

        @Override
        public Iterable<?> emptyCollection() {
            return CollectionLiterals.immutableSet();
        }
    }
    ,
    SORTED_SET(SortedSet.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            return collectionGenerator.sortedSet();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            return CollectionLiterals.immutableSortedSet(iterable);
        }

        @Override
        public Iterable<?> emptyCollection() {
            return CollectionLiterals.immutableSortedSet();
        }
    }
    ,
    ARRAY_MARKER(Iterable.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<?> emptyCollection() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    NO_ITERABLE(Iterable.class){

        @Override
        public Iterable<?> nextIterable(CollectionGenerator<?> collectionGenerator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<?> wrapToIterable(Iterable<?> iterable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<?> emptyCollection() {
            throw new UnsupportedOperationException();
        }
    };

    private final Class<? extends Iterable> iterableType;
    private static final List<CollectionType> SEARCH_ORDER;

    public abstract Iterable<?> nextIterable(CollectionGenerator<?> var1);

    public abstract Iterable<?> wrapToIterable(Iterable<?> var1);

    public abstract Iterable<?> emptyCollection();

    public static final Optional<CollectionType> findResponsibleCollectionType(Class<?> type) {
        if (null == type || type.isEnum()) {
            return Optional.empty();
        }
        if (type.isArray()) {
            return Optional.of(ARRAY_MARKER);
        }
        if (!type.isInterface() || !Iterable.class.isAssignableFrom(type)) {
            return Optional.empty();
        }
        for (CollectionType collectionType : SEARCH_ORDER) {
            if (!collectionType.iterableType.isAssignableFrom(type)) continue;
            return Optional.of(collectionType);
        }
        return Optional.empty();
    }

    @Generated
    private CollectionType(Class<? extends Iterable> iterableType) {
        this.iterableType = iterableType;
    }

    @Generated
    public Class<? extends Iterable> getIterableType() {
        return this.iterableType;
    }

    static {
        SEARCH_ORDER = CollectionLiterals.immutableList((Object[])new CollectionType[]{SORTED_SET, SET, LIST, COLLECTION});
    }
}

