/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.valueobjects.api.VerifyMapperConfiguration;
import de.cuioss.test.valueobjects.api.contracts.VerifyBeanProperty;
import de.cuioss.test.valueobjects.api.contracts.VerifyBuilder;
import de.cuioss.test.valueobjects.api.contracts.VerifyConstructor;
import de.cuioss.test.valueobjects.api.contracts.VerifyConstructors;
import de.cuioss.test.valueobjects.api.contracts.VerifyFactoryMethod;
import de.cuioss.test.valueobjects.api.contracts.VerifyFactoryMethods;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.BuilderMetadata;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.property.util.AssertionStrategy;
import de.cuioss.test.valueobjects.property.util.PropertyAccessStrategy;
import de.cuioss.test.valueobjects.util.BuilderPropertyHelper;
import de.cuioss.test.valueobjects.util.PropertyHelper;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyMemberInfo;
import de.cuioss.tools.property.PropertyReadWrite;
import de.cuioss.tools.reflect.MoreReflection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public final class AnnotationHelper {
    private static final String NO_PROPERTIES_GIVEN_IS_THIS_INTENTIONAL = "No properties given: Is this intentional?";
    static final String UNABLE_TO_INSTANTIATE_GENERATOR = "Unable to instantiate generator, You must provide a no-arg public constructor: ";
    private static final CuiLogger log = new CuiLogger(AnnotationHelper.class);

    public static List<PropertyMetadata> constructorConfigToPropertyMetadata(VerifyConstructor config, Collection<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(givenMetadata);
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
        List<String> ofAsList = Arrays.asList(config.of());
        givenMetadata.stream().filter(p -> ofAsList.contains(p.getName())).forEach(meta -> map.put(meta.getName(), (PropertyMetadata)meta));
        for (String name : config.of()) {
            PropertyHelper.assertPropertyExists(name, map);
            AnnotationHelper.modifyPropertyMetadata(map, config.defaultValued(), config.readOnly(), config.required(), config.transientProperties(), config.writeOnly(), config.assertUnorderedCollection());
        }
        if (config.allRequired()) {
            map.replaceAll((k, v) -> PropertyMetadataImpl.builder(v).required(true).build());
        }
        return AnnotationHelper.orderPropertyMetadata(config.of(), AnnotationHelper.handleWritableAttributes(map));
    }

    private static List<PropertyMetadata> handleWritableAttributes(Map<String, PropertyMetadata> map) {
        ArrayList<PropertyMetadata> result = new ArrayList<PropertyMetadata>();
        for (Map.Entry<String, PropertyMetadata> entry : map.entrySet()) {
            result.add(PropertyMetadataImpl.builder(entry.getValue()).propertyReadWrite(AnnotationHelper.determinePropertyReadWrite(entry.getValue())).build());
        }
        return result;
    }

    private static PropertyReadWrite determinePropertyReadWrite(PropertyMetadata propertyMetadata) {
        if (PropertyReadWrite.WRITE_ONLY.equals((Object)propertyMetadata.getPropertyReadWrite())) {
            return PropertyReadWrite.WRITE_ONLY;
        }
        return PropertyReadWrite.READ_WRITE;
    }

    public static List<PropertyMetadata> factoryConfigToPropertyMetadata(VerifyFactoryMethod config, Collection<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(givenMetadata);
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
        List<String> ofAsList = Arrays.asList(config.of());
        givenMetadata.stream().filter(p -> ofAsList.contains(p.getName())).forEach(meta -> map.put(meta.getName(), (PropertyMetadata)meta));
        for (String name : config.of()) {
            PropertyHelper.assertPropertyExists(name, map);
            AnnotationHelper.modifyPropertyMetadata(map, config.defaultValued(), config.readOnly(), config.required(), config.transientProperties(), config.writeOnly(), config.assertUnorderedCollection());
        }
        return AnnotationHelper.orderPropertyMetadata(config.of(), AnnotationHelper.handleWritableAttributes(map));
    }

    public static Set<VerifyConstructor> extractConfiguredConstructorContracts(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, VerifyConstructors.class).forEach(contract -> builder.add(Arrays.asList(contract.value())));
        MoreReflection.extractAllAnnotations(annotated, VerifyConstructor.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    public static Set<VerifyFactoryMethod> extractConfiguredFactoryContracts(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, VerifyFactoryMethods.class).forEach(contract -> builder.add(Arrays.asList(contract.value())));
        MoreReflection.extractAllAnnotations(annotated, VerifyFactoryMethod.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    public static List<PropertyMetadata> handleMetadataForPropertyTest(Class<?> annotated, List<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(annotated);
        Objects.requireNonNull(givenMetadata);
        if (givenMetadata.isEmpty()) {
            log.warn(NO_PROPERTIES_GIVEN_IS_THIS_INTENTIONAL);
            return givenMetadata;
        }
        Optional contractOption = MoreReflection.extractAnnotation(annotated, VerifyBeanProperty.class);
        VerifyBeanProperty contract = (VerifyBeanProperty)contractOption.orElseThrow(() -> new IllegalArgumentException("Given type does not provide the expected annotation BeanPropertyTestContract, type=" + annotated));
        Map<String, PropertyMetadata> map = PropertyHelper.handleWhiteAndBlacklist(contract.of(), contract.exclude(), givenMetadata);
        AnnotationHelper.modifyPropertyMetadata(map, contract.defaultValued(), contract.readOnly(), contract.required(), contract.transientProperties(), contract.writeOnly(), contract.assertUnorderedCollection());
        return AnnotationHelper.orderPropertyMetadata(contract.of(), map.values());
    }

    private static List<PropertyMetadata> orderPropertyMetadata(String[] of, Collection<PropertyMetadata> givenMetadata) {
        CollectionBuilder builder = new CollectionBuilder();
        if (0 == of.length) {
            builder.add(givenMetadata);
        } else {
            HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
            for (PropertyMetadata metadata : givenMetadata) {
                map.put(metadata.getName(), metadata);
            }
            for (String name : of) {
                builder.add((Object)((PropertyMetadata)map.get(name)));
            }
        }
        return builder.toImmutableList();
    }

    public static List<PropertyMetadata> handleMetadataForBuilderTest(Class<?> annotated, List<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(annotated);
        Objects.requireNonNull(givenMetadata);
        if (givenMetadata.isEmpty()) {
            log.warn(NO_PROPERTIES_GIVEN_IS_THIS_INTENTIONAL);
            return givenMetadata;
        }
        Optional contractOption = MoreReflection.extractAnnotation(annotated, VerifyBuilder.class);
        VerifyBuilder contract = (VerifyBuilder)contractOption.orElseThrow(() -> new IllegalArgumentException("Given type does not provide the expected annotation BuilderTestContract, type=" + annotated));
        Map<String, PropertyMetadata> map = PropertyHelper.handleWhiteAndBlacklist(contract.of(), contract.exclude(), givenMetadata);
        AnnotationHelper.modifyPropertyMetadata(map, contract.defaultValued(), contract.readOnly(), contract.required(), contract.transientProperties(), contract.writeOnly(), contract.assertUnorderedCollection());
        HashMap<String, PropertyMetadata> builderPropertyMap = new HashMap<String, PropertyMetadata>();
        for (PropertyMetadata propertyMetadata : BuilderPropertyHelper.handleBuilderPropertyConfigAnnotations(annotated, CollectionLiterals.mutableList(map.values()))) {
            Preconditions.checkArgument((boolean)map.containsKey(propertyMetadata.getName()), (String)("Invalid Configuration found: BuilderPropertyConfig and BuilderTestContract do not agree on configuration. offending property: " + propertyMetadata));
            builderPropertyMap.put(propertyMetadata.getName(), propertyMetadata);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (builderPropertyMap.containsKey(entry.getKey())) continue;
            PropertyMetadata delegate = (PropertyMetadata)entry.getValue();
            if (PropertyAccessStrategy.BEAN_PROPERTY.equals((Object)delegate.getPropertyAccessStrategy())) {
                PropertyReadWrite propertyReadWrite = PropertyReadWrite.READ_WRITE;
                if (PropertyReadWrite.WRITE_ONLY.equals((Object)delegate.getPropertyReadWrite())) {
                    propertyReadWrite = PropertyReadWrite.WRITE_ONLY;
                }
                delegate = PropertyMetadataImpl.builder(delegate).propertyAccessStrategy(PropertyAccessStrategy.BUILDER_DIRECT).propertyReadWrite(propertyReadWrite).build();
            }
            builderPropertyMap.put((String)entry.getKey(), BuilderMetadata.builder().delegateMetadata(delegate).builderMethodPrefix(contract.methodPrefix()).build());
        }
        return AnnotationHelper.orderPropertyMetadata(contract.of(), builderPropertyMap.values());
    }

    public static List<PropertyMetadata> handleMetadataForMapperTest(VerifyMapperConfiguration verifyMapper, List<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(verifyMapper);
        Objects.requireNonNull(givenMetadata);
        if (givenMetadata.isEmpty()) {
            log.warn(NO_PROPERTIES_GIVEN_IS_THIS_INTENTIONAL);
            return givenMetadata;
        }
        Map<String, PropertyMetadata> map = PropertyHelper.handleWhiteAndBlacklist(verifyMapper.of(), verifyMapper.exclude(), givenMetadata);
        AnnotationHelper.modifyPropertyMetadata(map, verifyMapper.defaultValued(), verifyMapper.readOnly(), verifyMapper.required(), new String[0], verifyMapper.writeOnly(), verifyMapper.assertUnorderedCollection());
        return AnnotationHelper.orderPropertyMetadata(verifyMapper.of(), map.values());
    }

    public static Map<String, PropertyMetadata> modifyPropertyMetadata(Map<String, PropertyMetadata> map, String[] defaultValued, String[] readOnly, String[] required, String[] transientProperties, String[] writeOnly, String[] unorderedCollection) {
        for (String name : defaultValued) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).defaultValue(true).build());
        }
        for (String name : readOnly) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).propertyReadWrite(PropertyReadWrite.READ_ONLY).build());
        }
        for (String name : writeOnly) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).propertyReadWrite(PropertyReadWrite.WRITE_ONLY).build());
        }
        for (String name : required) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).required(true).build());
        }
        for (String name : transientProperties) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).propertyMemberInfo(PropertyMemberInfo.TRANSIENT).build());
        }
        for (String name : unorderedCollection) {
            PropertyHelper.assertPropertyExists(name, map);
            map.put(name, PropertyMetadataImpl.builder(map.get(name)).assertionStrategy(AssertionStrategy.COLLECTION_IGNORE_ORDER).build());
        }
        return map;
    }

    public static Map<String, PropertyMetadata> modifyPropertyMetadata(Map<String, PropertyMetadata> map, List<String> defaultValued, List<String> readOnly, List<String> required, List<String> transientProperties, List<String> writeOnly, List<String> unorderedCollection) {
        return AnnotationHelper.modifyPropertyMetadata(map, defaultValued.toArray(new String[defaultValued.size()]), readOnly.toArray(new String[readOnly.size()]), required.toArray(new String[required.size()]), transientProperties.toArray(new String[transientProperties.size()]), writeOnly.toArray(new String[writeOnly.size()]), unorderedCollection.toArray(new String[unorderedCollection.size()]));
    }

    @Generated
    private AnnotationHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

