/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public final class DeepCopyTestHelper {
    public static void verifyDeepCopy(Object source, Object copy) {
        DeepCopyTestHelper.verifyDeepCopy(source, copy, Collections.emptyList());
    }

    public static void verifyDeepCopy(Object source, Object copy, Collection<String> ignoreProperties) {
        DeepCopyTestHelper.testDeepCopy(source, copy, null, ignoreProperties);
    }

    private static void testDeepCopy(Object source, Object copy, String propertyString, Collection<String> ignoreProperties) {
        Assertions.assertNotNull(ignoreProperties, (String)"ignore-properties my be empty but never null");
        Assertions.assertEquals((Object)source, (Object)copy);
        if (null == source) {
            return;
        }
        String currentPropertyString = DeepCopyTestHelper.determinePropertyString(propertyString);
        for (Method accessMethod : MoreReflection.retrieveAccessMethods(source.getClass(), ignoreProperties)) {
            String propertyName = MoreReflection.computePropertyNameFromMethodName((String)accessMethod.getName());
            try {
                Object resultCopy;
                Object resultSource = accessMethod.invoke(source, new Object[0]);
                if (!DeepCopyTestHelper.checkNullContract(resultSource, resultCopy = accessMethod.invoke(copy, new Object[0]), currentPropertyString, propertyName) || resultSource.getClass().isPrimitive() || resultSource.getClass().isEnum() || String.class.equals(resultSource.getClass()) || DeepCopyTestHelper.checkForList(resultSource, resultCopy, currentPropertyString, propertyName) || MoreReflection.retrieveWriteMethod(source.getClass(), (String)propertyName, resultSource.getClass()).isEmpty()) continue;
                Assertions.assertNotSame((Object)resultSource, (Object)resultCopy, (String)("deep copy failed with: " + currentPropertyString + propertyName + " (" + resultSource.toString() + ")"));
                DeepCopyTestHelper.testDeepCopy(resultSource, resultCopy, currentPropertyString + propertyName, Collections.emptyList());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Assertions.fail((String)("invoke method " + accessMethod.getName() + "failed: " + ExceptionHelper.extractCauseMessageFromThrowable(e)));
            }
        }
    }

    private static boolean checkNullContract(Object resultSource, Object resultCopy, String currentPropertyString, String propertyName) {
        if (null != resultSource) {
            if (null == resultCopy) {
                Assertions.fail((String)("property " + currentPropertyString + propertyName + " differs: " + resultSource.toString() + " != null"));
            }
        } else {
            if (null == resultCopy) {
                return false;
            }
            Assertions.fail((String)("property " + currentPropertyString + propertyName + " differs: null != " + resultCopy.toString()));
        }
        return true;
    }

    private static boolean checkForList(Object resultSource, Object resultCopy, String currentPropertyString, String propertyName) {
        if (!(resultSource instanceof List)) {
            return false;
        }
        List resultSourceList = (List)resultSource;
        for (int i = 0; i < resultSourceList.size(); ++i) {
            DeepCopyTestHelper.testDeepCopy(resultSourceList.get(i), ((List)resultCopy).get(i), currentPropertyString + propertyName + "[" + i + "]", Collections.emptyList());
        }
        return true;
    }

    private static String determinePropertyString(String propertyString) {
        if (MoreStrings.isEmpty((CharSequence)propertyString)) {
            return "";
        }
        return propertyString + ".";
    }

    @Generated
    private DeepCopyTestHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

