/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.valueobjects.api.property.PropertyConfig;
import de.cuioss.test.valueobjects.api.property.PropertyReflectionConfig;
import de.cuioss.test.valueobjects.generator.dynamic.GeneratorResolver;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.test.valueobjects.util.AnnotationHelper;
import de.cuioss.test.valueobjects.util.PropertyHelper;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyHolder;
import de.cuioss.tools.reflect.MoreReflection;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public final class ReflectionHelper {
    public static final Set<String> PROPERTY_IGNORE_SET = CollectionLiterals.immutableSet((Object)"class");
    private static final CuiLogger log = new CuiLogger(ReflectionHelper.class);

    public static <T> List<PropertyMetadata> handlePropertyMetadata(Class<?> annotated, Class<T> targetClass) {
        Objects.requireNonNull(annotated);
        Objects.requireNonNull(targetClass);
        ArrayList<PropertyMetadata> builder = new ArrayList<PropertyMetadata>();
        if (ReflectionHelper.shouldScanClass(annotated)) {
            TreeSet<PropertyMetadata> scanned = new TreeSet<PropertyMetadata>(ReflectionHelper.scanBeanTypeForProperties(targetClass, MoreReflection.extractAnnotation(annotated, PropertyReflectionConfig.class).orElse(null)));
            builder.addAll(ReflectionHelper.handlePostProcess(annotated, scanned));
        }
        Map<String, PropertyMetadata> mapView = PropertyHelper.toMapView(builder);
        PropertyHelper.handlePropertyConfigAnnotations(annotated).forEach(p -> mapView.put(p.getName(), (PropertyMetadata)p));
        Collection<PropertyMetadata> handled = PropertyHelper.handlePrimitiveAsDefaults(mapView.values());
        PropertyHelper.logMessageForPropertyMetadata(handled);
        return new ArrayList<PropertyMetadata>(handled);
    }

    public static <T> List<PropertyMetadata> handlePropertyMetadata(PropertyReflectionConfig propertyReflectionConfig, List<PropertyConfig> propertyConfig, Class<T> targetClass) {
        ArrayList<PropertyMetadata> builder = new ArrayList<PropertyMetadata>();
        if (ReflectionHelper.shouldScanClass(propertyReflectionConfig)) {
            TreeSet<PropertyMetadata> scanned = new TreeSet<PropertyMetadata>(ReflectionHelper.scanBeanTypeForProperties(targetClass, propertyReflectionConfig));
            builder.addAll(ReflectionHelper.handlePostProcessConfig(propertyReflectionConfig, scanned));
        }
        Map<String, PropertyMetadata> mapView = PropertyHelper.toMapView(builder);
        PropertyHelper.handlePropertyConfigAnnotations(propertyConfig).forEach(p -> mapView.put(p.getName(), (PropertyMetadata)p));
        Collection<PropertyMetadata> handled = PropertyHelper.handlePrimitiveAsDefaults(mapView.values());
        PropertyHelper.logMessageForPropertyMetadata(handled);
        return new ArrayList<PropertyMetadata>(handled);
    }

    public static SortedSet<PropertyMetadata> scanBeanTypeForProperties(Class<?> beanType, PropertyReflectionConfig config) {
        HashSet<String> filter = new HashSet<String>(PROPERTY_IGNORE_SET);
        if (null != config) {
            filter.addAll(Arrays.asList(config.exclude()));
        }
        CollectionBuilder found = new CollectionBuilder();
        CollectionBuilder builder = new CollectionBuilder();
        for (Method method : MoreReflection.retrieveAccessMethods(beanType)) {
            String attributeName = MoreReflection.computePropertyNameFromMethodName((String)method.getName());
            if (filter.contains(attributeName)) {
                log.debug("Filtering attribute '%s' for type '%s' as configured", new Object[]{attributeName, beanType});
                continue;
            }
            Optional holder = PropertyHolder.from(beanType, (String)attributeName);
            if (holder.isEmpty()) {
                log.info("Unable to extract metadata for type '%s' and method '%s'", new Object[]{beanType, method.getName()});
                continue;
            }
            builder.add((Object)((PropertyHolder)holder.get()));
        }
        for (PropertyHolder holder : builder) {
            found.add((Object)ReflectionHelper.createPropertyMetadata(beanType, holder));
        }
        return found.toImmutableNavigableSet();
    }

    public static PropertyMetadata createPropertyMetadata(Class<?> beanType, PropertyHolder propertyHolder) {
        Optional<CollectionType> collectionTypeOption;
        Objects.requireNonNull(beanType);
        Objects.requireNonNull(propertyHolder);
        CollectionType collectionType = CollectionType.NO_ITERABLE;
        Class<?> propertyType = propertyHolder.getType();
        Optional field = MoreReflection.accessField(beanType, (String)propertyHolder.getName());
        if (field.isPresent() && (collectionTypeOption = CollectionType.findResponsibleCollectionType(((Field)field.get()).getType())).isPresent()) {
            collectionType = collectionTypeOption.get();
            propertyType = CollectionType.ARRAY_MARKER.equals((Object)collectionType) ? ((Field)field.get()).getType().getComponentType() : ReflectionHelper.extractParameterizedType((Field)field.get(), (ParameterizedType)((Field)field.get()).getGenericType());
        }
        if (null == propertyType) {
            throw new IllegalArgumentException("Unable to extract property '%s' on type '%s'".formatted(propertyHolder.getName(), beanType.getName()));
        }
        boolean defaultValued = propertyType.isPrimitive();
        if (defaultValued && CollectionType.ARRAY_MARKER.equals((Object)collectionType)) {
            defaultValued = false;
        }
        return PropertyMetadataImpl.builder().name(propertyHolder.getName()).defaultValue(defaultValued).collectionType(collectionType).propertyMemberInfo(propertyHolder.getMemberInfo()).propertyReadWrite(propertyHolder.getReadWrite()).generator(GeneratorResolver.resolveGenerator(propertyType)).build();
    }

    private static Class<?> extractParameterizedType(Field field, ParameterizedType parameterizedType) {
        try {
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Unable to determine generic-type for %s, ususally this is the case with nested generics. \nYou need to provide a custom @PropertyConfig for this field and exclude it from scanning, by using PropertyReflectionConfig#exclude.\nSee package-javadoc of de.cuioss.test.valueobjects for samples.".formatted(field.toString()), e);
        }
    }

    public static SortedSet<PropertyMetadata> handlePostProcess(Class<?> annotated, SortedSet<PropertyMetadata> metatdata) {
        Objects.requireNonNull(annotated);
        Optional configOption = MoreReflection.extractAnnotation(annotated, PropertyReflectionConfig.class);
        return ReflectionHelper.handlePostProcessConfig(configOption.orElse(null), metatdata);
    }

    public static SortedSet<PropertyMetadata> handlePostProcessConfig(PropertyReflectionConfig config, SortedSet<PropertyMetadata> metatdata) {
        Objects.requireNonNull(metatdata);
        if (metatdata.isEmpty() || null == config) {
            return metatdata;
        }
        Map<String, PropertyMetadata> map = PropertyHelper.handleWhiteAndBlacklist(config.of(), config.exclude(), metatdata);
        map = AnnotationHelper.modifyPropertyMetadata(map, config.defaultValued(), config.readOnly(), config.required(), config.transientProperties(), config.writeOnly(), config.assertUnorderedCollection());
        return CollectionLiterals.immutableSortedSet(map.values());
    }

    public static boolean shouldScanClass(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        return ReflectionHelper.shouldScanClass(MoreReflection.extractAnnotation(annotated, PropertyReflectionConfig.class).orElse(null));
    }

    public static boolean shouldScanClass(PropertyReflectionConfig config) {
        if (null != config) {
            return !config.skip();
        }
        return true;
    }

    public static <T> Class<T> determineSupertypeFromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "iterable must not be null");
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next().getClass();
        }
        throw new IllegalArgumentException("Must contain at least a single element");
    }

    @Generated
    private ReflectionHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

