/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract.support;

import de.cuioss.test.valueobjects.api.VerifyMapperConfiguration;
import de.cuioss.test.valueobjects.contract.support.AssertTuple;
import de.cuioss.test.valueobjects.contract.support.MappingAssertStrategy;
import de.cuioss.test.valueobjects.contract.support.MappingTuple;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.logging.CuiLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public class MapperAttributesAsserts {
    private static final CuiLogger log = new CuiLogger(MapperAttributesAsserts.class);
    private static final String PROPERTY_MAPPING_INCOMPLETE = "Caution: you have unmapped {}-properties: {} you can adapt this behavior by either:\n- @VerifyMapperConfiguration(equals(\"name:firstName\"))\n- Make use of the provided property controls like @VerifyMapperConfiguration(of(\"name\"))";
    private final List<AssertTuple> sourceAsserts;

    public MapperAttributesAsserts(VerifyMapperConfiguration config, RuntimeProperties targetProperties, RuntimeProperties sourceProperties) {
        Map<String, PropertySupport> targetPropertyMap = targetProperties.asMapView(false);
        Map<String, PropertySupport> sourcePropertyMap = sourceProperties.asMapView(false);
        ArrayList<MappingTuple> mapping = new ArrayList<MappingTuple>(MappingAssertStrategy.EQUALS.readConfiguration(config));
        mapping.addAll(MappingAssertStrategy.NOT_NULL.readConfiguration(config));
        for (MappingTuple tuple : mapping) {
            Assertions.assertTrue((boolean)targetPropertyMap.containsKey(tuple.getTarget()), (String)("Invalid (unmapped) attribute-name for target: " + String.valueOf(tuple)));
            Assertions.assertTrue((boolean)sourcePropertyMap.containsKey(tuple.getSource()), (String)("Invalid (unmapped) attribute-name for source: " + String.valueOf(tuple)));
        }
        this.sourceAsserts = new ArrayList<AssertTuple>();
        for (MappingTuple tuple : mapping) {
            this.sourceAsserts.add(new AssertTuple(sourcePropertyMap.get(tuple.getSource()), targetPropertyMap.get(tuple.getTarget()), tuple));
        }
        this.logConfigurationStatus(targetProperties, sourceProperties);
    }

    private void logConfigurationStatus(RuntimeProperties targetProperties, RuntimeProperties sourceProperties) {
        if (this.sourceAsserts.isEmpty()) {
            log.warn("No attribute specific mapping found. use @VerifyMapperConfiguration(equals(\"name:firstName\")) or @VerifyMapperConfiguration(notNull(\"name:lastName\")) in order to activate");
        }
        Set sourceMappingNames = this.sourceAsserts.stream().map(a -> a.getMappingTuple().getSource()).collect(Collectors.toSet());
        Set targetMappingNames = this.sourceAsserts.stream().map(a -> a.getMappingTuple().getTarget()).collect(Collectors.toSet());
        Set<String> sourceTypeProperties = RuntimeProperties.extractNames(sourceProperties.getAllProperties());
        Set<String> targetTypeProperties = RuntimeProperties.extractNames(targetProperties.getAllProperties());
        sourceTypeProperties.removeAll(sourceMappingNames);
        targetTypeProperties.removeAll(targetMappingNames);
        if (sourceTypeProperties.isEmpty()) {
            log.info("All source-properties are covered.");
        } else {
            log.warn(PROPERTY_MAPPING_INCOMPLETE, new Object[]{"source", sourceTypeProperties});
        }
        if (targetTypeProperties.isEmpty()) {
            log.info("All target-properties are covered.");
        } else {
            log.warn(PROPERTY_MAPPING_INCOMPLETE, new Object[]{"target", targetTypeProperties});
        }
    }

    public void assertMappingForSourceAttributes(Collection<String> sourceAttributes, Object source, Object target) {
        if (this.sourceAsserts.isEmpty()) {
            return;
        }
        HashMap<String, List<AssertTuple>> asserts = new HashMap<String, List<AssertTuple>>();
        for (String name : sourceAttributes) {
            List<AssertTuple> concreteAsserts = this.sourceAsserts.stream().filter(a -> a.isResponsibleForSource(name)).toList();
            if (concreteAsserts.isEmpty()) {
                log.info("Checked property '{}' is not configured to be asserted, ist this intentional?", new Object[]{name});
                continue;
            }
            asserts.put(name, concreteAsserts);
        }
        if (asserts.isEmpty()) {
            return;
        }
        HashSet activeAsserts = new HashSet();
        asserts.values().forEach(activeAsserts::addAll);
        ArrayList<AssertTuple> nullAsserts = new ArrayList<AssertTuple>(this.sourceAsserts);
        nullAsserts.removeAll(activeAsserts);
        for (Map.Entry entry : asserts.entrySet()) {
            log.debug("Asserting attribute {}", new Object[]{entry.getKey()});
            ((List)entry.getValue()).forEach(a -> a.assertContract(source, target));
        }
        for (AssertTuple nullAssert : nullAsserts) {
            log.debug("Asserting attribute to be null / not set {}", new Object[]{nullAssert.getTargetSupport().getName()});
            MappingAssertStrategy.NULL_OR_DEFAULT.assertMapping(nullAssert.getSourceSupport(), source, nullAssert.getTargetSupport(), target);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapperAttributesAsserts)) {
            return false;
        }
        MapperAttributesAsserts other = (MapperAttributesAsserts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AssertTuple> this$sourceAsserts = this.sourceAsserts;
        List<AssertTuple> other$sourceAsserts = other.sourceAsserts;
        return !(this$sourceAsserts == null ? other$sourceAsserts != null : !((Object)this$sourceAsserts).equals(other$sourceAsserts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MapperAttributesAsserts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AssertTuple> $sourceAsserts = this.sourceAsserts;
        result = result * 59 + ($sourceAsserts == null ? 43 : ((Object)$sourceAsserts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MapperAttributesAsserts(sourceAsserts=" + String.valueOf(this.sourceAsserts) + ")";
    }
}

