/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.generator.dynamic.impl;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.valueobjects.generator.TypedGeneratorRegistry;
import de.cuioss.test.valueobjects.generator.dynamic.GeneratorResolver;
import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.Joiner;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class ConstructorBasedGenerator<T>
implements TypedGenerator<T> {
    private static final CuiLogger log = new CuiLogger(ConstructorBasedGenerator.class);
    private static final String UNABLE_TO_CALL_CONSTRUCTOR_FOR_CLASS = "Unable to call constructor '%s' for class '%s' due to: '%s'";
    @NonNull
    private final Class<T> type;
    @NonNull
    private final List<TypedGenerator<?>> constructorGenerators;
    @NonNull
    private final Constructor<T> constructor;

    public T next() {
        if (this.constructorGenerators.isEmpty()) {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(UNABLE_TO_CALL_CONSTRUCTOR_FOR_CLASS.formatted(this.constructor, this.type, e.getMessage()), e);
            }
        }
        ArrayList<Object> parameter = new ArrayList<Object>();
        this.constructorGenerators.forEach(gen -> parameter.add(gen.next()));
        try {
            this.logExtendedInformationAboutUsedConstructor(parameter);
            return this.constructor.newInstance(parameter.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(UNABLE_TO_CALL_CONSTRUCTOR_FOR_CLASS.formatted(this.constructor, this.type, ExceptionHelper.extractCauseMessageFromThrowable(e)), e);
        }
    }

    private void logExtendedInformationAboutUsedConstructor(ArrayList<Object> parameterValues) {
        int constructorModifierValue = this.constructor.getModifiers();
        if (!Modifier.isPublic(constructorModifierValue)) {
            log.warn("!!! Attention : A non public constructor will be used to create an instance for {}. This is illegal and can cause unexpected behaviour. Solution: provide a fitting generator instead!", new Object[]{this.constructor.getName()});
            ArrayList<CallSite> parameterInfo = new ArrayList<CallSite>(this.constructor.getParameters().length);
            for (Parameter parameter : this.constructor.getParameters()) {
                parameterInfo.add((CallSite)((Object)(parameter.getType().getSimpleName() + " " + parameter.getName())));
            }
            String modifier = Modifier.toString(constructorModifierValue);
            String constructorInfo = modifier + " " + this.constructor.getName() + "(" + Joiner.on((String)", ").skipNulls().join(parameterInfo) + ")";
            log.info("Used constructor : {}", new Object[]{constructorInfo});
            log.info("Used constructor parameter : {}", new Object[]{ConstructorBasedGenerator.logUsedValuesForConstructor(parameterValues)});
        }
    }

    private static String logUsedValuesForConstructor(ArrayList<Object> parameter) {
        ArrayList<CallSite> parameterInfo = new ArrayList<CallSite>();
        for (Object object : parameter) {
            parameterInfo.add((CallSite)((Object)("[" + object.getClass().getSimpleName() + " " + String.valueOf(object) + "]")));
        }
        return Joiner.on((String)", ").skipNulls().join(parameterInfo);
    }

    public Class<T> getType() {
        return this.type;
    }

    public static final <T> Optional<TypedGenerator<T>> getGeneratorForType(Class<T> type) {
        if (!ConstructorBasedGenerator.isReponsibleForType(type)) {
            return Optional.empty();
        }
        List<Constructor<?>> constructors = Arrays.asList(type.getDeclaredConstructors());
        if (constructors.isEmpty()) {
            log.warn("Unable to determine constructor for class {} ", new Object[]{type});
            return Optional.empty();
        }
        constructors.sort(Comparator.comparingInt(Constructor::getParameterCount));
        List<Constructor<?>> filteredConstructors = constructors.stream().filter(c -> Modifier.isPublic(c.getModifiers())).toList();
        if (!filteredConstructors.isEmpty()) {
            return ConstructorBasedGenerator.findFittingConstructor(type, filteredConstructors);
        }
        filteredConstructors = constructors.stream().filter(c -> Modifier.isProtected(c.getModifiers())).toList();
        if (!filteredConstructors.isEmpty()) {
            return ConstructorBasedGenerator.findFittingConstructor(type, filteredConstructors);
        }
        filteredConstructors = constructors.stream().filter(c -> 0 == c.getModifiers()).toList();
        if (!filteredConstructors.isEmpty()) {
            return ConstructorBasedGenerator.findFittingConstructor(type, filteredConstructors);
        }
        filteredConstructors = constructors.stream().filter(c -> Modifier.isPrivate(c.getModifiers())).toList();
        if (!filteredConstructors.isEmpty()) {
            return ConstructorBasedGenerator.findFittingConstructor(type, filteredConstructors);
        }
        log.warn("Unable to determine constructor for class {} ", new Object[]{type});
        return Optional.empty();
    }

    private static boolean isReponsibleForType(Class<?> type) {
        if (null == type || type.isAnnotation()) {
            return false;
        }
        return !type.isEnum() && !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    private static <T> Optional<TypedGenerator<T>> findFittingConstructor(Class<T> type, List<Constructor<?>> constructorList) {
        log.debug("Searching constructor for class {}", new Object[]{type});
        if (1 == constructorList.size()) {
            log.debug("Only one constructor present, so choosing this one");
            return ConstructorBasedGenerator.createForConstructor(type, constructorList.getFirst());
        }
        for (Constructor<?> con : constructorList) {
            Class<?>[] parameter = con.getParameterTypes();
            boolean allGeneratorAvailable = true;
            for (Class<?> param : parameter) {
                if (TypedGeneratorRegistry.containsGenerator(param)) continue;
                allGeneratorAvailable = false;
                log.debug("Missing generator for {}", new Object[]{param});
                break;
            }
            if (!allGeneratorAvailable) continue;
            return ConstructorBasedGenerator.createForConstructor(type, con);
        }
        log.warn("No valid constructor found for class {}", new Object[]{type});
        for (Constructor<?> con : constructorList) {
            if (1 == con.getParameterCount() && con.getParameterTypes()[0].equals(type)) {
                log.debug("Skipping copy constructor...");
                continue;
            }
            return ConstructorBasedGenerator.createForConstructor(type, con);
        }
        throw new IllegalStateException("No matching constructor found for class " + String.valueOf(type));
    }

    private static <T> Optional<TypedGenerator<T>> createForConstructor(Class<T> type, Constructor<?> con) {
        Constructor<?> constructor = con;
        constructor.setAccessible(true);
        ArrayList generators = new ArrayList();
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (parameterType.equals(type)) {
                log.warn("Unable to create a generator for copy-constuctor of same type for class {}, constructor parameter type = {}", new Object[]{type, parameterType});
                return Optional.empty();
            }
            generators.add(GeneratorResolver.resolveGenerator(parameterType));
        }
        return Optional.of(new ConstructorBasedGenerator<T>(type, generators, constructor));
    }

    @Generated
    private ConstructorBasedGenerator(@NonNull Class<T> type, @NonNull List<TypedGenerator<?>> constructorGenerators, @NonNull Constructor<T> constructor) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (constructorGenerators == null) {
            throw new NullPointerException("constructorGenerators is marked non-null but is null");
        }
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        this.type = type;
        this.constructorGenerators = constructorGenerators;
        this.constructor = constructor;
    }

    @Generated
    public String toString() {
        return "ConstructorBasedGenerator(type=" + String.valueOf(this.getType()) + ", constructorGenerators=" + String.valueOf(this.constructorGenerators) + ", constructor=" + String.valueOf(this.constructor) + ")";
    }
}

