/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.junit5.extension;

import de.cuioss.test.valueobjects.generator.TypedGeneratorRegistry;
import de.cuioss.test.valueobjects.util.GeneratorAnnotationHelper;
import de.cuioss.test.valueobjects.util.GeneratorRegistry;
import de.cuioss.tools.logging.CuiLogger;
import java.util.Collections;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class GeneratorRegistryController
implements TestInstancePostProcessor,
AfterAllCallback {
    private static final CuiLogger LOGGER = new CuiLogger(GeneratorRegistryController.class);

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        LOGGER.debug(() -> "Clearing TypedGeneratorRegistry registry");
        TypedGeneratorRegistry.clear();
        if (testInstance instanceof GeneratorRegistry) {
            GeneratorRegistry registry = (GeneratorRegistry)testInstance;
            LOGGER.debug(() -> "Test-class '" + String.valueOf(testInstance.getClass()) + "' is of type de.cuioss.test.valueobjects.util.GeneratorRegistry, initializing Generator framework");
            GeneratorAnnotationHelper.handleGeneratorsForTestClass(registry, registry.registerAdditionalGenerators());
        } else {
            LOGGER.debug(() -> "Test-class '{" + String.valueOf(testInstance.getClass()) + "}' is NOT of type de.cuioss.test.valueobjects.util.GeneratorRegistry, initializing Generator framework without local Generator");
            GeneratorAnnotationHelper.handleGeneratorsForTestClass(testInstance, Collections.emptyList());
        }
    }

    public void afterAll(ExtensionContext context) {
        LOGGER.debug(() -> "Tearing down TypedGeneratorRegistry registry");
        TypedGeneratorRegistry.clear();
    }
}

