/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.objects;

import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.collect.MapBuilder;
import de.cuioss.tools.string.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import lombok.Generated;

public class RuntimeProperties {
    private final List<PropertyMetadata> allProperties;
    private final List<PropertyMetadata> requiredProperties;
    private final List<PropertyMetadata> additionalProperties;
    private final List<PropertyMetadata> defaultProperties;
    private final List<PropertyMetadata> writableProperties;

    public RuntimeProperties(List<? extends PropertyMetadata> properties) {
        this.allProperties = null == properties ? Collections.emptyList() : CollectionLiterals.immutableList(properties);
        this.requiredProperties = this.allProperties.stream().filter(PropertyMetadata::isRequired).toList();
        this.additionalProperties = this.allProperties.stream().filter(metadata -> !metadata.isRequired()).toList();
        this.defaultProperties = this.allProperties.stream().filter(PropertyMetadata::isDefaultValue).toList();
        this.writableProperties = this.allProperties.stream().filter(metadata -> metadata.getPropertyReadWrite().isWriteable()).toList();
    }

    public RuntimeProperties(SortedSet<PropertyMetadata> properties) {
        this(CollectionLiterals.immutableList(properties));
    }

    public static List<PropertySupport> mapToPropertySupport(Collection<PropertyMetadata> propertyMetadata, boolean generateTestValue) {
        ArrayList<PropertySupport> list = new ArrayList<PropertySupport>();
        if (null == propertyMetadata || propertyMetadata.isEmpty()) {
            return list;
        }
        propertyMetadata.forEach(p -> list.add(new PropertySupport((PropertyMetadata)p)));
        if (generateTestValue) {
            list.forEach(PropertySupport::generateTestValue);
        }
        return list;
    }

    public List<PropertySupport> getAllAsPropertySupport(boolean generateTestValue) {
        return RuntimeProperties.mapToPropertySupport(this.getAllProperties(), generateTestValue);
    }

    public List<PropertySupport> getAllAsPropertySupport(boolean generateTestValue, Collection<String> filter) {
        Objects.requireNonNull(filter);
        return this.getAllAsPropertySupport(generateTestValue).stream().filter(s -> filter.contains(s.getName())).toList();
    }

    public List<PropertySupport> getRequiredAsPropertySupport(boolean generateTestValue) {
        return RuntimeProperties.mapToPropertySupport(this.getRequiredProperties(), generateTestValue);
    }

    public List<PropertySupport> getRequiredAsPropertySupport(boolean generateTestValue, Collection<String> filter) {
        Objects.requireNonNull(filter);
        return this.getRequiredAsPropertySupport(generateTestValue).stream().filter(s -> filter.contains(s.getName())).toList();
    }

    public List<PropertySupport> getDefaultAsPropertySupport(boolean generateTestValue) {
        return RuntimeProperties.mapToPropertySupport(this.getDefaultProperties(), generateTestValue);
    }

    public List<PropertySupport> getDefaultAsPropertySupport(boolean generateTestValue, Collection<String> filter) {
        Objects.requireNonNull(filter);
        return this.getDefaultAsPropertySupport(generateTestValue).stream().filter(s -> filter.contains(s.getName())).toList();
    }

    public List<PropertySupport> getAdditionalAsPropertySupport(boolean generateTestValue) {
        return RuntimeProperties.mapToPropertySupport(this.getAdditionalProperties(), generateTestValue);
    }

    public List<PropertySupport> getAdditionalAsPropertySupport(boolean generateTestValue, Collection<String> filter) {
        Objects.requireNonNull(filter);
        return this.getAdditionalAsPropertySupport(generateTestValue).stream().filter(s -> filter.contains(s.getName())).toList();
    }

    public List<PropertySupport> getWritableAsPropertySupport(boolean generateTestValue) {
        return RuntimeProperties.mapToPropertySupport(this.getWritableProperties(), generateTestValue);
    }

    public List<PropertySupport> getWritableAsPropertySupport(boolean generateTestValue, Collection<String> filter) {
        Objects.requireNonNull(filter);
        return this.getWritableAsPropertySupport(generateTestValue).stream().filter(s -> filter.contains(s.getName())).toList();
    }

    public Map<String, PropertySupport> asMapView(boolean generateTestValue) {
        MapBuilder builder = new MapBuilder();
        this.getAllAsPropertySupport(generateTestValue).forEach(p -> builder.put((Object)p.getName(), p));
        return builder.toImmutableMap();
    }

    public static final Set<String> extractNames(Collection<PropertyMetadata> metadata) {
        if (null == metadata || metadata.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> builder = new HashSet<String>();
        metadata.forEach(m -> builder.add(m.getName()));
        return builder;
    }

    public String toString() {
        return this.getClass().getName() + "\nRequired properties: " + RuntimeProperties.getPropertyNames(this.requiredProperties) + "\nAdditional properties: " + RuntimeProperties.getPropertyNames(this.additionalProperties) + "\nDefault valued properties: " + RuntimeProperties.getPropertyNames(this.defaultProperties) + "\nWritable properties: " + RuntimeProperties.getPropertyNames(this.writableProperties);
    }

    private static String getPropertyNames(List<PropertyMetadata> properties) {
        if (null == properties || properties.isEmpty()) {
            return "-";
        }
        ArrayList names = new ArrayList();
        properties.forEach(p -> names.add(p.getName()));
        return Joiner.on((String)", ").join(names);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeProperties)) {
            return false;
        }
        RuntimeProperties other = (RuntimeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PropertyMetadata> this$allProperties = this.getAllProperties();
        List<PropertyMetadata> other$allProperties = other.getAllProperties();
        return !(this$allProperties == null ? other$allProperties != null : !((Object)this$allProperties).equals(other$allProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RuntimeProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PropertyMetadata> $allProperties = this.getAllProperties();
        result = result * 59 + ($allProperties == null ? 43 : ((Object)$allProperties).hashCode());
        return result;
    }

    @Generated
    public List<PropertyMetadata> getAllProperties() {
        return this.allProperties;
    }

    @Generated
    public List<PropertyMetadata> getRequiredProperties() {
        return this.requiredProperties;
    }

    @Generated
    public List<PropertyMetadata> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Generated
    public List<PropertyMetadata> getDefaultProperties() {
        return this.defaultProperties;
    }

    @Generated
    public List<PropertyMetadata> getWritableProperties() {
        return this.writableProperties;
    }
}

