/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.property.impl;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.impl.CollectionGenerator;
import de.cuioss.test.generator.impl.PrimitiveArrayGenerators;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.util.AssertionStrategy;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.test.valueobjects.property.util.PropertyAccessStrategy;
import de.cuioss.tools.property.PropertyMemberInfo;
import de.cuioss.tools.property.PropertyReadWrite;
import de.cuioss.tools.string.Joiner;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;

public class PropertyMetadataImpl
implements PropertyMetadata {
    private final String name;
    private final TypedGenerator<?> generator;
    private final boolean defaultValue;
    private final Class<?> propertyClass;
    private final Class<?> actualClass;
    private final boolean required;
    private final PropertyAccessStrategy propertyAccessStrategy;
    private final CollectionType collectionType;
    private final PropertyMemberInfo propertyMemberInfo;
    private final PropertyReadWrite propertyReadWrite;
    private final AssertionStrategy assertionStrategy;

    @Override
    public Object next() {
        switch (this.collectionType) {
            case NO_ITERABLE: {
                return this.generator.next();
            }
            case ARRAY_MARKER: {
                if (!this.propertyClass.isPrimitive()) {
                    return this.resolveCollectionGenerator().list().toArray();
                }
                return PrimitiveArrayGenerators.resolveForType(this.getPropertyClass()).next();
            }
        }
        return this.collectionType.nextIterable(this.resolveCollectionGenerator());
    }

    @Override
    public CollectionGenerator<?> resolveCollectionGenerator() {
        return new CollectionGenerator(this.generator);
    }

    @Override
    public Class<?> resolveActualClass() {
        return this.actualClass;
    }

    public static PropertyMetadataBuilder builder() {
        return new PropertyMetadataBuilder();
    }

    public static PropertyMetadataBuilder builder(PropertyMetadata copyFrom) {
        PropertyMetadataBuilder builder = PropertyMetadataImpl.builder();
        Objects.requireNonNull(copyFrom);
        builder.collectionType(copyFrom.getCollectionType()).defaultValue(copyFrom.isDefaultValue());
        builder.generator(copyFrom.getGenerator()).name(copyFrom.getName());
        builder.propertyAccessStrategy(copyFrom.getPropertyAccessStrategy());
        builder.propertyClass(copyFrom.getPropertyClass());
        builder.propertyMemberInfo(copyFrom.getPropertyMemberInfo());
        builder.propertyReadWrite(copyFrom.getPropertyReadWrite());
        builder.required(copyFrom.isRequired());
        builder.assertionStrategy(copyFrom.getAssertionStrategy());
        return builder;
    }

    @Override
    public int compareTo(PropertyMetadata other) {
        return this.name.compareTo(other.getName());
    }

    public String toString() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add("'" + this.getName() + "' (" + String.valueOf(this.getPropertyClass()) + ")");
        if (this.isRequired()) {
            elements.add("required");
        }
        if (this.isDefaultValue()) {
            elements.add("defaultValued");
        }
        elements.add(this.getGenerator());
        if (!CollectionType.NO_ITERABLE.equals((Object)this.getCollectionType())) {
            elements.add((Object)this.getCollectionType());
            elements.add("actualClass: " + String.valueOf(this.actualClass));
        }
        elements.add(this.getPropertyReadWrite());
        elements.add((Object)this.getPropertyAccessStrategy());
        if (!AssertionStrategy.DEFAULT.equals((Object)this.getAssertionStrategy())) {
            elements.add((Object)this.getAssertionStrategy());
        }
        return Joiner.on((String)", ").join(elements);
    }

    @Generated
    PropertyMetadataImpl(String name, TypedGenerator<?> generator, boolean defaultValue, Class<?> propertyClass, Class<?> actualClass, boolean required, PropertyAccessStrategy propertyAccessStrategy, CollectionType collectionType, PropertyMemberInfo propertyMemberInfo, PropertyReadWrite propertyReadWrite, AssertionStrategy assertionStrategy) {
        this.name = name;
        this.generator = generator;
        this.defaultValue = defaultValue;
        this.propertyClass = propertyClass;
        this.actualClass = actualClass;
        this.required = required;
        this.propertyAccessStrategy = propertyAccessStrategy;
        this.collectionType = collectionType;
        this.propertyMemberInfo = propertyMemberInfo;
        this.propertyReadWrite = propertyReadWrite;
        this.assertionStrategy = assertionStrategy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyMetadataImpl)) {
            return false;
        }
        PropertyMetadataImpl other = (PropertyMetadataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.defaultValue != other.defaultValue) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$propertyClass = this.propertyClass;
        Class<?> other$propertyClass = other.propertyClass;
        if (this$propertyClass == null ? other$propertyClass != null : !this$propertyClass.equals(other$propertyClass)) {
            return false;
        }
        Class<?> this$actualClass = this.actualClass;
        Class<?> other$actualClass = other.actualClass;
        if (this$actualClass == null ? other$actualClass != null : !this$actualClass.equals(other$actualClass)) {
            return false;
        }
        PropertyAccessStrategy this$propertyAccessStrategy = this.propertyAccessStrategy;
        PropertyAccessStrategy other$propertyAccessStrategy = other.propertyAccessStrategy;
        if (this$propertyAccessStrategy == null ? other$propertyAccessStrategy != null : !((Object)((Object)this$propertyAccessStrategy)).equals((Object)other$propertyAccessStrategy)) {
            return false;
        }
        CollectionType this$collectionType = this.collectionType;
        CollectionType other$collectionType = other.collectionType;
        if (this$collectionType == null ? other$collectionType != null : !((Object)((Object)this$collectionType)).equals((Object)other$collectionType)) {
            return false;
        }
        PropertyMemberInfo this$propertyMemberInfo = this.propertyMemberInfo;
        PropertyMemberInfo other$propertyMemberInfo = other.propertyMemberInfo;
        if (this$propertyMemberInfo == null ? other$propertyMemberInfo != null : !this$propertyMemberInfo.equals(other$propertyMemberInfo)) {
            return false;
        }
        PropertyReadWrite this$propertyReadWrite = this.propertyReadWrite;
        PropertyReadWrite other$propertyReadWrite = other.propertyReadWrite;
        if (this$propertyReadWrite == null ? other$propertyReadWrite != null : !this$propertyReadWrite.equals(other$propertyReadWrite)) {
            return false;
        }
        AssertionStrategy this$assertionStrategy = this.assertionStrategy;
        AssertionStrategy other$assertionStrategy = other.assertionStrategy;
        return !(this$assertionStrategy == null ? other$assertionStrategy != null : !((Object)((Object)this$assertionStrategy)).equals((Object)other$assertionStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyMetadataImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.defaultValue ? 79 : 97);
        result = result * 59 + (this.required ? 79 : 97);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $propertyClass = this.propertyClass;
        result = result * 59 + ($propertyClass == null ? 43 : $propertyClass.hashCode());
        Class<?> $actualClass = this.actualClass;
        result = result * 59 + ($actualClass == null ? 43 : $actualClass.hashCode());
        PropertyAccessStrategy $propertyAccessStrategy = this.propertyAccessStrategy;
        result = result * 59 + ($propertyAccessStrategy == null ? 43 : ((Object)((Object)$propertyAccessStrategy)).hashCode());
        CollectionType $collectionType = this.collectionType;
        result = result * 59 + ($collectionType == null ? 43 : ((Object)((Object)$collectionType)).hashCode());
        PropertyMemberInfo $propertyMemberInfo = this.propertyMemberInfo;
        result = result * 59 + ($propertyMemberInfo == null ? 43 : $propertyMemberInfo.hashCode());
        PropertyReadWrite $propertyReadWrite = this.propertyReadWrite;
        result = result * 59 + ($propertyReadWrite == null ? 43 : $propertyReadWrite.hashCode());
        AssertionStrategy $assertionStrategy = this.assertionStrategy;
        result = result * 59 + ($assertionStrategy == null ? 43 : ((Object)((Object)$assertionStrategy)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public TypedGenerator<?> getGenerator() {
        return this.generator;
    }

    @Override
    @Generated
    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Generated
    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    @Override
    @Generated
    public boolean isRequired() {
        return this.required;
    }

    @Override
    @Generated
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.propertyAccessStrategy;
    }

    @Override
    @Generated
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    @Generated
    public PropertyMemberInfo getPropertyMemberInfo() {
        return this.propertyMemberInfo;
    }

    @Override
    @Generated
    public PropertyReadWrite getPropertyReadWrite() {
        return this.propertyReadWrite;
    }

    @Override
    @Generated
    public AssertionStrategy getAssertionStrategy() {
        return this.assertionStrategy;
    }

    public static class PropertyMetadataBuilder {
        private TypedGenerator<?> tempGenerator;
        private String tempName;
        private boolean tempDefaultValue = false;
        private Class<?> tempPropertyClass;
        private boolean tempRequired = false;
        private PropertyMemberInfo tempPropertyMemberInfo = PropertyMemberInfo.DEFAULT;
        private CollectionType tempCollectionType = CollectionType.NO_ITERABLE;
        private PropertyAccessStrategy tempPropertyAccessStrategy = PropertyAccessStrategy.BEAN_PROPERTY;
        private PropertyReadWrite tempPropertyReadWrite = PropertyReadWrite.READ_WRITE;
        private AssertionStrategy tempAssertionStrategy = AssertionStrategy.DEFAULT;

        public PropertyMetadataBuilder propertyAccessStrategy(PropertyAccessStrategy propertyAccessStrategy) {
            this.tempPropertyAccessStrategy = propertyAccessStrategy;
            return this;
        }

        public PropertyMetadataBuilder propertyReadWrite(PropertyReadWrite propertyReadWrite) {
            this.tempPropertyReadWrite = propertyReadWrite;
            return this;
        }

        public PropertyMetadataBuilder assertionStrategy(AssertionStrategy assertionStrategy) {
            this.tempAssertionStrategy = assertionStrategy;
            return this;
        }

        public PropertyMetadataBuilder generator(TypedGenerator<?> typedGenerator) {
            this.tempGenerator = typedGenerator;
            this.tempPropertyClass = typedGenerator.getType();
            return this;
        }

        public PropertyMetadataBuilder name(String name) {
            this.tempName = MoreStrings.emptyToNull((String)name);
            return this;
        }

        public PropertyMetadataBuilder defaultValue(boolean defaultValue) {
            this.tempDefaultValue = defaultValue;
            return this;
        }

        public PropertyMetadataBuilder collectionType(CollectionType collectionType) {
            this.tempCollectionType = collectionType;
            return this;
        }

        public PropertyMetadataBuilder propertyClass(Class<?> propertyClass) {
            this.tempPropertyClass = propertyClass;
            return this;
        }

        public PropertyMetadataBuilder required(boolean required) {
            this.tempRequired = required;
            return this;
        }

        public PropertyMetadataBuilder propertyMemberInfo(PropertyMemberInfo propertyMemberInfo) {
            Objects.requireNonNull(propertyMemberInfo, "objectMemberInfo");
            this.tempPropertyMemberInfo = propertyMemberInfo;
            return this;
        }

        public PropertyMetadataImpl build() {
            Objects.requireNonNull(this.tempName, "name");
            Objects.requireNonNull(this.tempGenerator, "generator");
            Objects.requireNonNull(this.tempPropertyClass, "propertyClass");
            Class<Object> actualClass = this.tempPropertyClass;
            if (!CollectionType.NO_ITERABLE.equals((Object)this.tempCollectionType)) {
                actualClass = CollectionType.ARRAY_MARKER.equals((Object)this.tempCollectionType) ? Array.newInstance(this.tempPropertyClass, 0).getClass() : this.tempCollectionType.getIterableType();
            }
            return new PropertyMetadataImpl(this.tempName, this.tempGenerator, this.tempDefaultValue, this.tempPropertyClass, actualClass, this.tempRequired, this.tempPropertyAccessStrategy, this.tempCollectionType, this.tempPropertyMemberInfo, this.tempPropertyReadWrite, this.tempAssertionStrategy);
        }
    }
}

