/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.property.util;

import de.cuioss.test.valueobjects.objects.impl.ExceptionHelper;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.BuilderMetadata;
import de.cuioss.test.valueobjects.property.util.CollectionType;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyUtil;
import de.cuioss.tools.reflect.MoreReflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;

public enum PropertyAccessStrategy {
    BEAN_PROPERTY{

        @Override
        public Object writeProperty(Object target, PropertyMetadata propertyMetadata, Object propertyValue) {
            Assertions.assertNotNull((Object)target, (String)PropertyAccessStrategy.TARGET_MUST_NOT_BE_NULL);
            Assertions.assertNotNull((Object)target, (String)PropertyAccessStrategy.PROPERTY_METADATA_MUST_NOT_BE_NULL);
            try {
                PropertyUtil.writeProperty((Object)target, (String)propertyMetadata.getName(), (Object)propertyValue);
                return target;
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new AssertionError(PropertyAccessStrategy.UNABLE_TO_SET_PROPERTY.formatted(propertyMetadata.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e)), e);
            }
        }

        @Override
        public Object readProperty(Object target, PropertyMetadata propertyMetadata) {
            Assertions.assertNotNull((Object)target, (String)PropertyAccessStrategy.TARGET_MUST_NOT_BE_NULL);
            Assertions.assertNotNull((Object)target, (String)PropertyAccessStrategy.PROPERTY_METADATA_MUST_NOT_BE_NULL);
            try {
                return PropertyUtil.readProperty((Object)target, (String)propertyMetadata.getName());
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new AssertionError(PropertyAccessStrategy.UNABLE_TO_READ_PROPERTY.formatted(propertyMetadata.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e)), e);
            }
        }
    }
    ,
    BUILDER_COLLECTION_AND_SINGLE_ELEMENT{

        @Override
        public Object writeProperty(Object target, PropertyMetadata propertyMetadata, Object propertyValue) {
            BuilderMetadata builderMetadata;
            if (!(propertyValue instanceof Iterable)) {
                throw new AssertionError((Object)("Invalid valueType given, must be at least Iterable, but was " + String.valueOf(propertyValue)));
            }
            Iterable iterable = (Iterable)propertyValue;
            List elements = CollectionLiterals.mutableList((Iterable)iterable);
            if (!(propertyMetadata instanceof BuilderMetadata)) {
                builderMetadata = BuilderMetadata.wrapFromMetadata(propertyMetadata);
            } else {
                BuilderMetadata metadata = (BuilderMetadata)propertyMetadata;
                builderMetadata = metadata;
            }
            try {
                if (!elements.isEmpty()) {
                    Object singleElement = elements.getFirst();
                    Method writeAddMethod = target.getClass().getMethod(builderMetadata.getBuilderSingleAddMethodName(), propertyMetadata.getPropertyClass());
                    writeAddMethod.invoke(target, singleElement);
                    elements.remove(singleElement);
                }
                Method writeCollectionMethod = this.determineCollectionWriteMethod(target, propertyMetadata, builderMetadata);
                return writeCollectionMethod.invoke(target, propertyMetadata.getCollectionType().wrapToIterable(elements));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AssertionError(PropertyAccessStrategy.UNABLE_TO_SET_PROPERTY.formatted(propertyMetadata.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e)), e);
            }
        }

        private Method determineCollectionWriteMethod(Object target, PropertyMetadata propertyMetadata, BuilderMetadata builderMetadata) throws NoSuchMethodException {
            try {
                return target.getClass().getMethod(builderMetadata.getBuilderAddMethodName(), propertyMetadata.getCollectionType().getIterableType());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return target.getClass().getMethod(builderMetadata.getBuilderAddMethodName(), CollectionType.COLLECTION.getIterableType());
            }
        }

        @Override
        public Object readProperty(Object target, PropertyMetadata propertyMetadata) {
            return BEAN_PROPERTY.readProperty(target, propertyMetadata);
        }
    }
    ,
    BUILDER_DIRECT{

        @Override
        public Object writeProperty(Object target, PropertyMetadata propertyMetadata, Object propertyValue) {
            BuilderMetadata builderMetadata;
            if (!(propertyMetadata instanceof BuilderMetadata)) {
                builderMetadata = BuilderMetadata.wrapFromMetadata(propertyMetadata);
            } else {
                BuilderMetadata metadata = (BuilderMetadata)propertyMetadata;
                builderMetadata = metadata;
            }
            try {
                Method writeMethod = target.getClass().getMethod(builderMetadata.getBuilderAddMethodName(), propertyMetadata.resolveActualClass());
                return writeMethod.invoke(target, propertyValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                String message = PropertyAccessStrategy.UNABLE_TO_SET_PROPERTY.formatted(propertyMetadata.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e));
                new CuiLogger(((Object)((Object)this)).getClass()).error(message);
                throw new AssertionError(message, e);
            }
        }

        @Override
        public Object readProperty(Object target, PropertyMetadata propertyMetadata) {
            return BEAN_PROPERTY.readProperty(target, propertyMetadata);
        }
    }
    ,
    FLUENT_WRITER{

        @Override
        public Object writeProperty(Object target, PropertyMetadata propertyMetadata, Object propertyValue) {
            Optional writeMethod = MoreReflection.retrieveWriteMethod(target.getClass(), (String)propertyMetadata.getName(), propertyMetadata.resolveActualClass());
            if (writeMethod.isEmpty()) {
                throw new AssertionError((Object)PropertyAccessStrategy.UNABLE_TO_SET_PROPERTY.formatted(propertyMetadata.getName(), "No write-method could be found"));
            }
            try {
                return ((Method)writeMethod.get()).invoke(target, propertyValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                throw new AssertionError(PropertyAccessStrategy.UNABLE_TO_SET_PROPERTY.formatted(propertyMetadata.getName(), ExceptionHelper.extractCauseMessageFromThrowable(e)), e);
            }
        }

        @Override
        public Object readProperty(Object target, PropertyMetadata propertyMetadata) {
            return BEAN_PROPERTY.readProperty(target, propertyMetadata);
        }
    };

    private static final String UNABLE_TO_READ_PROPERTY = "Unable to read property '%s' because of '%s'";
    private static final String TARGET_MUST_NOT_BE_NULL = "target must not be null";
    private static final String PROPERTY_METADATA_MUST_NOT_BE_NULL = "propertyMetadata must not be null";
    private static final String UNABLE_TO_SET_PROPERTY = "Unable to set property '%s' because of '%s'";

    public abstract Object writeProperty(Object var1, PropertyMetadata var2, Object var3);

    public abstract Object readProperty(Object var1, PropertyMetadata var2);
}

