/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.util;

import de.cuioss.test.valueobjects.api.property.PropertyBuilderConfig;
import de.cuioss.test.valueobjects.api.property.PropertyBuilderConfigs;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.impl.BuilderMetadata;
import de.cuioss.test.valueobjects.property.impl.PropertyMetadataImpl;
import de.cuioss.test.valueobjects.util.PropertyHelper;
import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.reflect.MoreReflection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public final class BuilderPropertyHelper {
    public static List<PropertyMetadata> handleBuilderPropertyConfigAnnotations(Class<?> annotated, List<PropertyMetadata> givenMetadata) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        BuilderPropertyHelper.extractConfiguredPropertyBuilderConfigs(annotated).forEach(config -> builder.add((Object)BuilderPropertyHelper.builderPropertyConfigToBuilderMetadata(config, givenMetadata)));
        return builder.toImmutableList();
    }

    public static Set<PropertyBuilderConfig> extractConfiguredPropertyBuilderConfigs(Class<?> annotated) {
        Objects.requireNonNull(annotated);
        CollectionBuilder builder = new CollectionBuilder();
        MoreReflection.extractAllAnnotations(annotated, PropertyBuilderConfigs.class).forEach(contract -> builder.add(Arrays.asList(contract.value())));
        MoreReflection.extractAllAnnotations(annotated, PropertyBuilderConfig.class).forEach(arg_0 -> ((CollectionBuilder)builder).add(arg_0));
        return builder.toImmutableSet();
    }

    private static PropertyMetadata builderPropertyConfigToBuilderMetadata(PropertyBuilderConfig config, Collection<PropertyMetadata> givenMetadata) {
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>();
        givenMetadata.forEach(meta -> map.put(meta.getName(), (PropertyMetadata)meta));
        PropertyHelper.assertPropertyExists(config.name(), map);
        PropertyMetadataImpl metatada = PropertyMetadataImpl.builder((PropertyMetadata)map.get(config.name())).propertyAccessStrategy(config.propertyAccessStrategy()).build();
        return BuilderMetadata.builder().delegateMetadata(metatada).builderMethodName(config.builderMethodName()).builderMethodPrefix(config.methodPrefix()).builderSingleAddMethodName(config.builderSingleAddMethodName()).build();
    }

    @Generated
    private BuilderPropertyHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

