/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects;

import de.cuioss.test.valueobjects.api.VerifyMapperConfiguration;
import de.cuioss.test.valueobjects.api.property.PropertyReflectionConfig;
import de.cuioss.test.valueobjects.contract.MapperContractImpl;
import de.cuioss.test.valueobjects.generator.dynamic.GeneratorResolver;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.TestObjectProvider;
import de.cuioss.test.valueobjects.objects.impl.BeanInstantiator;
import de.cuioss.test.valueobjects.objects.impl.DefaultInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.util.AnnotationHelper;
import de.cuioss.test.valueobjects.util.GeneratorRegistry;
import de.cuioss.test.valueobjects.util.PropertyHelper;
import de.cuioss.test.valueobjects.util.ReflectionHelper;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.reflect.MoreReflection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapperTest<M extends Function<S, T>, S, T>
implements GeneratorRegistry,
TestObjectProvider<M> {
    private Class<M> mapperClass;
    private Class<? extends S> sourceClass;
    private Class<T> targetClass;

    protected void intializeTypeInformation() {
        if (null == this.mapperClass) {
            ParameterizedType parameterized = (ParameterizedType)MoreReflection.extractParameterizedType(this.getClass()).orElseThrow(() -> new IllegalArgumentException("Given type defines no generic Type: " + String.valueOf(this.getClass())));
            List types = CollectionLiterals.immutableList((Object[])parameterized.getActualTypeArguments());
            Preconditions.checkArgument((3 == types.size() ? 1 : 0) != 0, (String)"Super Class must provide 3 generic types in order to work");
            this.mapperClass = (Class)MoreReflection.extractGenericTypeCovariantly((Type)((Type)types.getFirst())).orElseThrow(() -> new AssertionError((Object)("Unable to determine mapperClass from type" + String.valueOf(this.getClass()))));
            Assertions.assertNotNull(this.mapperClass, (String)"Unable to determine mapperClass");
            Assertions.assertFalse((boolean)this.mapperClass.isInterface(), (String)("This type only works with concrete implementations, but was the interface " + String.valueOf(this.mapperClass)));
            this.sourceClass = (Class)MoreReflection.extractGenericTypeCovariantly((Type)((Type)types.get(1))).orElseThrow(() -> new AssertionError((Object)("Unable to determine sourceClass from type" + String.valueOf(this.getClass()))));
            Assertions.assertNotNull(this.sourceClass, (String)"Unable to determine sourceClass");
            this.targetClass = (Class)MoreReflection.extractGenericTypeCovariantly((Type)((Type)types.get(2))).orElseThrow(() -> new AssertionError((Object)("Unable to determine targetClass from type" + String.valueOf(this.getClass()))));
            Assertions.assertNotNull(this.targetClass, (String)"Unable to determine targetClass");
        }
    }

    @Test
    protected void verifyMapper() {
        this.verifyMapper(null);
    }

    public void verifyMapper(PropertyReflectionConfig targetConfig) {
        this.intializeTypeInformation();
        Optional config = MoreReflection.extractAnnotation(this.getClass(), VerifyMapperConfiguration.class);
        Assertions.assertTrue((boolean)config.isPresent(), (String)("The mapper test must be annotated with " + VerifyMapperConfiguration.class.getName()));
        List<PropertyMetadata> processedSourceProperties = AnnotationHelper.handleMetadataForMapperTest((VerifyMapperConfiguration)config.get(), this.resolveSourcePropertyMetadata());
        ParameterizedInstantiator<S> sourceInstantiator = this.getSourceInstantiator(new RuntimeProperties(processedSourceProperties));
        RuntimeProperties targetProperties = new RuntimeProperties(this.resolveTargetPropertyMetadata(targetConfig));
        new MapperContractImpl((VerifyMapperConfiguration)config.get(), sourceInstantiator, targetProperties, this.getUnderTest()).assertContract();
    }

    @Override
    public M getUnderTest() {
        this.intializeTypeInformation();
        return (M)((Function)new DefaultInstantiator<M>(this.mapperClass).newInstance());
    }

    public List<PropertyMetadata> resolveSourcePropertyMetadata() {
        this.intializeTypeInformation();
        return ReflectionHelper.handlePropertyMetadata(this.getClass(), this.getSourceClass());
    }

    public List<PropertyMetadata> resolveTargetPropertyMetadata(PropertyReflectionConfig config) {
        this.intializeTypeInformation();
        ArrayList<PropertyMetadata> builder = new ArrayList<PropertyMetadata>();
        if (ReflectionHelper.shouldScanClass(this.getClass())) {
            TreeSet<PropertyMetadata> scanned = new TreeSet<PropertyMetadata>(ReflectionHelper.scanBeanTypeForProperties(this.anyTargetObject().getClass(), config));
            builder.addAll(ReflectionHelper.handlePostProcessConfig(config, scanned));
        }
        Collection<PropertyMetadata> handled = PropertyHelper.handlePrimitiveAsDefaults(PropertyHelper.toMapView(builder).values());
        PropertyHelper.logMessageForTargetPropertyMetadata(handled);
        return CollectionLiterals.immutableList(handled);
    }

    public T anyTargetObject() {
        this.intializeTypeInformation();
        return (T)GeneratorResolver.resolveGenerator(this.targetClass).next();
    }

    public ParameterizedInstantiator<? extends S> getSourceInstantiator(RuntimeProperties runtimeProperties) {
        this.intializeTypeInformation();
        return new BeanInstantiator<S>(new DefaultInstantiator<S>(this.getSourceClass()), runtimeProperties);
    }

    @Generated
    protected Class<M> getMapperClass() {
        return this.mapperClass;
    }

    @Generated
    protected Class<? extends S> getSourceClass() {
        return this.sourceClass;
    }

    @Generated
    protected Class<T> getTargetClass() {
        return this.targetClass;
    }
}

