/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects;

import de.cuioss.test.valueobjects.PropertyAwareTest;
import de.cuioss.test.valueobjects.api.ObjectContractTestSupport;
import de.cuioss.test.valueobjects.api.TestContract;
import de.cuioss.test.valueobjects.api.object.ObjectTestConfig;
import de.cuioss.test.valueobjects.api.object.ObjectTestContracts;
import de.cuioss.test.valueobjects.contract.ContractRegistry;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.impl.AbstractInlineInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.util.ObjectContractHelper;
import de.cuioss.tools.collect.CollectionLiterals;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValueObjectTest<T>
extends PropertyAwareTest<T>
implements ObjectContractTestSupport {
    public static final String ANY_VALUE_OBJECT_NEEDED = "You need to configure either at least one de.cuioss.test.valueobjects.api.contracts or implement #anyValueObject()";
    private Set<ObjectTestContracts> activeObjectContracts;
    private List<ParameterizedInstantiator<T>> objectContractInstantiator;
    private List<TestContract<T>> testContracts;

    @BeforeEach
    void initializeBaseClass() {
        this.activeObjectContracts = ObjectContractHelper.handleVetoedContracts(this.getClass());
        this.testContracts = this.resolveTestContracts(this.getPropertyMetadata());
        this.objectContractInstantiator = new ArrayList<ParameterizedInstantiator<T>>();
        this.testContracts.forEach(contract -> this.objectContractInstantiator.add(contract.getInstantiator()));
    }

    protected List<TestContract<T>> resolveTestContracts(List<PropertyMetadata> initialMetadata) {
        return ContractRegistry.resolveTestContracts(this.getTargetBeanClass(), this.getClass(), initialMetadata);
    }

    @Override
    @Test
    public void shouldImplementObjectContracts() {
        List instantiators = this.getObjectContractInstantiator();
        if (instantiators.isEmpty()) {
            Assertions.assertNotNull(this.anyValueObject(), (String)ANY_VALUE_OBJECT_NEEDED);
            instantiators = CollectionLiterals.immutableList((Object)new AbstractInlineInstantiator<T>(){

                @Override
                protected T any() {
                    return ValueObjectTest.this.anyValueObject();
                }
            });
        }
        ObjectTestConfig objectTestConfig = this.getClass().getAnnotation(ObjectTestConfig.class);
        for (ParameterizedInstantiator<T> instantiator : instantiators) {
            for (ObjectTestContracts objectTestContracts : this.activeObjectContracts) {
                objectTestContracts.newObjectTestInstance().assertContract(instantiator, objectTestConfig);
            }
        }
    }

    @Test
    final void shouldVerifyTestContracts() {
        for (TestContract<T> contract : this.getTestContracts()) {
            contract.assertContract();
        }
    }

    protected T anyValueObject() {
        if (!this.getObjectContractInstantiator().isEmpty()) {
            return this.getObjectContractInstantiator().getFirst().newInstanceFull();
        }
        return null;
    }

    @Generated
    protected List<ParameterizedInstantiator<T>> getObjectContractInstantiator() {
        return this.objectContractInstantiator;
    }

    @Generated
    public List<TestContract<T>> getTestContracts() {
        return this.testContracts;
    }
}

