/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.TestContract;
import de.cuioss.test.valueobjects.api.contracts.VerifyBeanProperty;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.objects.impl.BeanInstantiator;
import de.cuioss.test.valueobjects.objects.impl.DefaultInstantiator;
import de.cuioss.test.valueobjects.property.PropertyMetadata;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.test.valueobjects.util.AnnotationHelper;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyReadWrite;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class BeanPropertyContractImpl<T>
implements TestContract<T> {
    private static final CuiLogger LOGGER = new CuiLogger(BeanPropertyContractImpl.class);
    @NonNull
    private final ParameterizedInstantiator<T> instantiator;

    @Override
    public void assertContract() {
        LOGGER.info("Verifying " + this.getClass().getName() + "\nWith configuration: " + String.valueOf(this.getInstantiator()));
        this.checkGetterAndSetterContract();
        this.checkDefaultContract();
    }

    private void checkGetterAndSetterContract() {
        List<PropertyMetadata> readWriteProperties = this.getInstantiator().getRuntimeProperties().getAllProperties().stream().filter(p -> PropertyReadWrite.READ_WRITE.equals((Object)p.getPropertyReadWrite())).toList();
        if (readWriteProperties.isEmpty()) {
            LOGGER.warn("There are no properties defined that are readable and writable. Consider your configuration and/or the base class for your test.");
        } else {
            LOGGER.info("Verifying properties that are Read and Write: " + String.valueOf(RuntimeProperties.extractNames(readWriteProperties)));
            List<PropertySupport> supportList = readWriteProperties.stream().map(PropertySupport::new).toList();
            T target = this.getInstantiator().newInstanceMinimal();
            for (PropertySupport support : supportList) {
                support.generateTestValue();
                support.apply(target);
                support.assertValueSet(target);
            }
        }
    }

    private void checkDefaultContract() {
        List<PropertyMetadata> defaultProperties = this.getInstantiator().getRuntimeProperties().getDefaultProperties();
        if (defaultProperties.isEmpty()) {
            LOGGER.debug("No default properties configured");
        } else {
            List<PropertySupport> defaultPropertySupport = defaultProperties.stream().map(PropertySupport::new).toList();
            T target = this.getInstantiator().newInstanceMinimal();
            for (PropertySupport support : defaultPropertySupport) {
                support.assertDefaultValue(target);
            }
        }
    }

    public static final <T> Optional<TestContract<T>> createBeanPropertyTestContract(Class<T> beanType, Class<?> annotated, List<PropertyMetadata> initialPropertyMetadata) {
        Objects.requireNonNull(beanType, "beantype must not be null");
        Objects.requireNonNull(annotated, "annotated must not be null");
        Objects.requireNonNull(initialPropertyMetadata, "initialPropertyMetadata must not be null");
        if (!annotated.isAnnotationPresent(VerifyBeanProperty.class)) {
            LOGGER.debug("No annotation of type BeanPropertyTestContract available on class: " + String.valueOf(annotated));
            return Optional.empty();
        }
        if (initialPropertyMetadata.isEmpty()) {
            LOGGER.warn("No configured properties found to be tested, offending class: " + String.valueOf(annotated));
            return Optional.empty();
        }
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(beanType);
        List<PropertyMetadata> metadata = AnnotationHelper.handleMetadataForPropertyTest(annotated, initialPropertyMetadata);
        return Optional.of(new BeanPropertyContractImpl<T>(new BeanInstantiator<T>(instantiator, new RuntimeProperties(metadata))));
    }

    @Generated
    public BeanPropertyContractImpl(@NonNull ParameterizedInstantiator<T> instantiator) {
        if (instantiator == null) {
            throw new NullPointerException("instantiator is marked non-null but is null");
        }
        this.instantiator = instantiator;
    }

    @Override
    @NonNull
    @Generated
    public ParameterizedInstantiator<T> getInstantiator() {
        return this.instantiator;
    }
}

