/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.object.ObjectTestConfig;
import de.cuioss.test.valueobjects.api.object.ObjectTestContract;
import de.cuioss.test.valueobjects.contract.ReflectionUtil;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.property.PropertyMemberInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.junit.jupiter.api.Assertions;

public class EqualsAndHashcodeContractImpl
implements ObjectTestContract {
    private static final Integer DEFAULT_INT_VALUE = 0;
    private static final CuiLogger LOGGER = new CuiLogger(EqualsAndHashcodeContractImpl.class);

    @Override
    public void assertContract(ParameterizedInstantiator<?> instantiator, ObjectTestConfig objectTestConfig) {
        Objects.requireNonNull(instantiator, "parameterizedInstantiator must not be null");
        LOGGER.info("Verifying " + this.getClass().getName() + "\nWith configuration: " + String.valueOf(instantiator));
        Object target = instantiator.newInstanceMinimal();
        EqualsAndHashcodeContractImpl.assertBasicContractOnEquals(target);
        ReflectionUtil.assertHashCodeMethodIsOverriden(target.getClass());
        EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(target);
        if (EqualsAndHashcodeContractImpl.shouldTestPropertyContract(objectTestConfig)) {
            EqualsAndHashcodeContractImpl.executePropertyTests(instantiator, objectTestConfig);
        } else {
            LOGGER.info("Only checking basic contract of equals() and hasCode()");
        }
    }

    private static void executePropertyTests(ParameterizedInstantiator<?> instantiator, ObjectTestConfig objectTestConfig) {
        TreeSet<String> consideredAttributes = new TreeSet<String>();
        instantiator.getRuntimeProperties().getWritableProperties().stream().filter(p -> PropertyMemberInfo.DEFAULT.equals((Object)p.getPropertyMemberInfo())).forEach(p -> consideredAttributes.add(p.getName()));
        if (null != objectTestConfig) {
            if (objectTestConfig.equalsAndHashCodeOf().length > 0) {
                consideredAttributes.clear();
                consideredAttributes.addAll(Arrays.asList(objectTestConfig.equalsAndHashCodeOf()));
            } else {
                Arrays.asList(objectTestConfig.equalsAndHashCodeExclude()).forEach(consideredAttributes::remove);
            }
        }
        if (consideredAttributes.isEmpty()) {
            LOGGER.debug("No configured properties to be tested. Is this intentional?");
        } else {
            LOGGER.info("Configured attributes found for equalsAndHashCode-testing: " + String.valueOf(consideredAttributes));
            EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithVariants(instantiator, consideredAttributes);
        }
    }

    private static boolean shouldTestPropertyContract(ObjectTestConfig objectTestConfig) {
        return null == objectTestConfig || !objectTestConfig.equalsAndHashCodeBasicOnly();
    }

    private static void assertEqualsAndHashCodeWithVariants(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        EqualsAndHashcodeContractImpl.assertEqualsAndHasCodeWithAllPropertiesSet(instantiator, consideredAttributes);
        EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithSkippingProperties(instantiator, consideredAttributes);
        EqualsAndHashcodeContractImpl.assertEqualsAndHashCodeWithChangingProperties(instantiator, consideredAttributes);
    }

    private static void assertEqualsAndHasCodeWithAllPropertiesSet(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        ArrayList<String> actualAttributes = new ArrayList<String>(consideredAttributes);
        Set<String> requiredNames = RuntimeProperties.extractNames(instantiator.getRuntimeProperties().getRequiredProperties());
        actualAttributes.addAll(requiredNames);
        List<PropertySupport> properties = instantiator.getRuntimeProperties().getWritableAsPropertySupport(true, actualAttributes);
        Object fullObject1 = instantiator.newInstance(properties, false);
        Object fullObject2 = instantiator.newInstance(properties, false);
        Assertions.assertEquals(fullObject1, fullObject2, (String)"Objects should be equal with all properties set");
        Assertions.assertEquals(fullObject2, fullObject1, (String)"Objects should be equal with all properties set, but are not symmetric");
        EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(fullObject1);
    }

    private static void assertEqualsAndHashCodeWithSkippingProperties(ParameterizedInstantiator<?> instantiator, Set<String> consideredAttributes) {
        RuntimeProperties information = instantiator.getRuntimeProperties();
        List<PropertySupport> allWritableProperties = information.getWritableAsPropertySupport(true).stream().filter(prop -> consideredAttributes.contains(prop.getName())).toList();
        List<PropertySupport> nonDefaultProperties = allWritableProperties.stream().filter(prop -> !prop.isDefaultValue()).toList();
        List<PropertySupport> requiredProperties = nonDefaultProperties.stream().filter(PropertySupport::isRequired).toList();
        List<PropertySupport> additionalProperties = nonDefaultProperties.stream().filter(property -> !property.isRequired()).toList();
        int upperBound = Math.min(nonDefaultProperties.size(), consideredAttributes.size()) - 2;
        if (additionalProperties.isEmpty()) {
            LOGGER.info("Only required or default properties found, therefore no further testing");
        } else {
            Object minimalObject = instantiator.newInstance(requiredProperties, false);
            Object fullObject = instantiator.newInstance(allWritableProperties, false);
            ArrayList<PropertySupport> iteratingProperties = new ArrayList<PropertySupport>(requiredProperties);
            EqualsAndHashcodeContractImpl.verifyProperties(instantiator, additionalProperties, upperBound, minimalObject, fullObject, iteratingProperties);
            iteratingProperties = new ArrayList<PropertySupport>(requiredProperties);
            EqualsAndHashcodeContractImpl.verifyPropertiesInReverse(instantiator, additionalProperties, upperBound, minimalObject, fullObject, iteratingProperties);
        }
    }

    private static void verifyProperties(ParameterizedInstantiator<?> instantiator, List<PropertySupport> additionalProperties, int upperBound, Object minimalObject, Object fullObject, List<PropertySupport> iteratingProperties) {
        for (PropertySupport support : additionalProperties) {
            if (iteratingProperties.size() < upperBound) {
                iteratingProperties.add(support);
            } else {
                iteratingProperties.add(support.createCopyWithNonEqualValue());
            }
            Object iterating = instantiator.newInstance(iteratingProperties, false);
            String current = support.getName();
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(minimalObject, iterating, current);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(fullObject, iterating, current);
            EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(iterating);
        }
    }

    private static void verifyPropertiesInReverse(ParameterizedInstantiator<?> instantiator, List<PropertySupport> additionalProperties, int upperBound, Object minimalObject, Object fullObject, List<PropertySupport> iteratingProperties) {
        for (int i = additionalProperties.size() - 1; i >= 0; --i) {
            PropertySupport support = additionalProperties.get(i);
            if (iteratingProperties.size() < upperBound) {
                iteratingProperties.add(support);
            } else {
                iteratingProperties.add(support.createCopyWithNonEqualValue());
            }
            Object iterating = instantiator.newInstance(iteratingProperties, false);
            String current = support.getName();
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(minimalObject, iterating, current);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(fullObject, iterating, current);
            EqualsAndHashcodeContractImpl.assertBasicContractOnHashCode(iterating);
        }
    }

    private static void assertEqualsAndHashCodeWithChangingProperties(ParameterizedInstantiator<?> instantiator, SortedSet<String> consideredAttributes) {
        HashMap allWritableProperties = new HashMap();
        instantiator.getRuntimeProperties().getWritableAsPropertySupport(true).forEach(p -> allWritableProperties.put(p.getName(), p));
        Object expected = instantiator.newInstance(new ArrayList<PropertySupport>(allWritableProperties.values()), false);
        for (String name : consideredAttributes) {
            HashMap<String, PropertySupport> current = new HashMap<String, PropertySupport>(allWritableProperties);
            Assertions.assertTrue((boolean)current.containsKey(name), (String)("Invalid configuration found: " + name + " not defined as property."));
            current.put(name, ((PropertySupport)current.get(name)).createCopyWithNonEqualValue());
            Object actual = instantiator.newInstance(new ArrayList<PropertySupport>(current.values()), false);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(expected, actual, name);
        }
        String[] attributesArray = consideredAttributes.toArray(new String[0]);
        for (int i = attributesArray.length - 1; i >= 0; --i) {
            String name = attributesArray[i];
            HashMap<String, PropertySupport> current = new HashMap<String, PropertySupport>(allWritableProperties);
            Assertions.assertTrue((boolean)current.containsKey(name), (String)("Invalid configuration found: " + name + " not defined as property."));
            current.put(name, ((PropertySupport)current.get(name)).createCopyWithNonEqualValue());
            Object actual = instantiator.newInstance(new ArrayList<PropertySupport>(current.values()), false);
            EqualsAndHashcodeContractImpl.assertEqualObjectAreNotEqual(expected, actual, name);
        }
    }

    private static void assertEqualObjectAreNotEqual(Object expected, Object actual, String deltaPropertyName) {
        String message = "The Objects of type " + expected.getClass().getName() + " should not be equal, current property=" + deltaPropertyName;
        Assertions.assertNotEquals((Object)expected, (Object)actual, (String)message);
        Assertions.assertNotEquals((Object)actual, (Object)expected, (String)message);
    }

    public static void assertBasicContractOnEquals(Object underTest) {
        ReflectionUtil.assertEqualsMethodIsOverriden(underTest.getClass());
        String msgNotEqualsNull = "Expected result for equals(null) will be 'false'. Class was : " + String.valueOf(underTest.getClass());
        Assertions.assertNotEquals(null, (Object)underTest, (String)msgNotEqualsNull);
        String msgNotEqualsObject = "Expected result for equals(new Object()) will be 'false'. Class was : " + String.valueOf(underTest.getClass());
        Assertions.assertNotEquals((Object)new Object(), (Object)underTest, (String)msgNotEqualsObject);
        String msgEqualsToSelf = "Expected result for equals(underTest) will be 'true'. Class was : " + String.valueOf(underTest.getClass());
        Assertions.assertEquals((Object)underTest, (Object)underTest, (String)msgEqualsToSelf);
    }

    public static void assertBasicContractOnHashCode(Object underTest) {
        Assertions.assertNotEquals((Integer)DEFAULT_INT_VALUE, (int)underTest.hashCode(), (String)("Expected result of hashCode method is not '0'. Class was : " + String.valueOf(underTest.getClass())));
    }
}

