/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import de.cuioss.test.valueobjects.api.VerifyMapperConfiguration;
import de.cuioss.test.valueobjects.contract.support.MapperAttributesAsserts;
import de.cuioss.test.valueobjects.objects.ParameterizedInstantiator;
import de.cuioss.test.valueobjects.objects.RuntimeProperties;
import de.cuioss.test.valueobjects.property.PropertySupport;
import de.cuioss.tools.logging.CuiLogger;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public class MapperContractImpl<S, T> {
    private static final CuiLogger LOGGER = new CuiLogger(MapperContractImpl.class);
    @NonNull
    private final VerifyMapperConfiguration config;
    @NonNull
    private final ParameterizedInstantiator<? extends S> sourceInstantiator;
    @NonNull
    private final RuntimeProperties targetMetadata;
    @NonNull
    private final Function<S, T> mapper;

    public void assertContract() {
        String builder = "Verifying " + this.getClass().getName() + "\nWith source-configuration: " + this.sourceInstantiator.getRuntimeProperties().toString() + "\nWith target-configuration: " + String.valueOf(this.targetMetadata);
        LOGGER.info(builder);
        MapperAttributesAsserts asserter = new MapperAttributesAsserts(this.config, this.targetMetadata, this.sourceInstantiator.getRuntimeProperties());
        this.handleSimpleMapping(asserter);
    }

    private void handleSimpleMapping(MapperAttributesAsserts asserter) {
        LOGGER.info("Testing mimimal Mapping for mapper-class %s", new Object[]{this.mapper.getClass()});
        this.verifyMapping(asserter, this.sourceInstantiator.getRuntimeProperties().getRequiredAsPropertySupport(true), "minimal-instance");
        LOGGER.info("Testing full Mapping for mapper-class %s", new Object[]{this.mapper.getClass()});
        this.verifyMapping(asserter, this.sourceInstantiator.getRuntimeProperties().getWritableAsPropertySupport(true), "full-instance");
    }

    private void verifyMapping(MapperAttributesAsserts asserter, List<PropertySupport> properties, String context) {
        S source = this.sourceInstantiator.newInstance(properties, false);
        T target = this.mapper.apply(source);
        List<String> names = properties.stream().map(PropertySupport::getName).toList();
        LOGGER.debug("Verifying mapper in context of %s with attributes %s", new Object[]{context, names});
        asserter.assertMappingForSourceAttributes(names, source, target);
    }

    @Generated
    public MapperContractImpl(@NonNull VerifyMapperConfiguration config, @NonNull ParameterizedInstantiator<? extends S> sourceInstantiator, @NonNull RuntimeProperties targetMetadata, @NonNull Function<S, T> mapper) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (sourceInstantiator == null) {
            throw new NullPointerException("sourceInstantiator is marked non-null but is null");
        }
        if (targetMetadata == null) {
            throw new NullPointerException("targetMetadata is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        this.config = config;
        this.sourceInstantiator = sourceInstantiator;
        this.targetMetadata = targetMetadata;
        this.mapper = mapper;
    }
}

