/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.valueobjects.contract;

import java.lang.reflect.Method;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public final class ReflectionUtil {
    static final String METHOD_NAME_OBJECT_EQUALS = "equals";
    static final String METHOD_NAME_OBJECT_HASH_CODE = "hashCode";
    static final String METHOD_NAME_OBJECT_TO_STRING = "toString";

    public static void assertEqualsMethodIsOverriden(Class<?> clazz) {
        Class[] args1 = new Class[]{Object.class};
        Method method = ReflectionUtil.getMethodFromClass(clazz, METHOD_NAME_OBJECT_EQUALS, args1);
        String assertText = "Method 'equals' not implemented in the class : " + clazz.getName();
        ReflectionUtil.assertJavaLangObjectMethodWasOverridden(assertText, method);
    }

    public static void assertHashCodeMethodIsOverriden(Class<?> clazz) {
        Method method = ReflectionUtil.getMethodFromClass(clazz, METHOD_NAME_OBJECT_HASH_CODE, null);
        String assertText = "Method 'hashCode' not implemented in the class : " + clazz.getName();
        ReflectionUtil.assertJavaLangObjectMethodWasOverridden(assertText, method);
    }

    public static void assertToStringMethodIsOverriden(Class<?> clazz) {
        Method method = ReflectionUtil.getMethodFromClass(clazz, METHOD_NAME_OBJECT_TO_STRING, null);
        String assertText = "Method 'toString' not implemented in the class : " + clazz.getName();
        ReflectionUtil.assertJavaLangObjectMethodWasOverridden(assertText, method);
    }

    private static void assertJavaLangObjectMethodWasOverridden(String assertText, Method method) {
        Assertions.assertNotNull((Object)method, (String)assertText);
        Assertions.assertNotEquals(Object.class, method.getDeclaringClass(), (String)assertText);
    }

    private static Method getMethodFromClass(Class<?> clazz, String methodName, Class<?>[] args1) {
        Assertions.assertNotNull(clazz, (String)"Target for test is null");
        Method result = null;
        try {
            result = null != args1 ? clazz.getMethod(methodName, args1) : clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
        Assertions.assertNotNull((Object)result, (String)("Method " + methodName + " does not exist on " + String.valueOf(clazz)));
        return result;
    }

    @Generated
    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

